stm8/

	#include "mapping.inc"
  #include "STM8S103F3P.inc"

	PUBLIC	UART_init
	PUBLIC	putc
	PUBLIC	puts
	PUBLIC	getc
	PUBLIC	gets

	#define GETLINE_BUF_SIZE  80
	#define GETLINE_SAVE_SIZE	32
	#define GET_SAVETIMEOUT   10000
	
	segment 'ram1'

;  ,  
;static char buffer[GETLINE_BUF_SIZE];
gets_buffer	ds.b	GETLINE_BUF_SIZE
;static char save_buffer[GET_SAVEBUF_SIZE];
gets_save		ds.b	GETLINE_SAVE_SIZE

	segment 'ram0'

;  ,  
;static char XonXoff = 0;
XonXoff.b			ds.b	1
;static int save_count = 0;
save_count.b	ds.b	1
;static int save_total = 0;
save_total.b	ds.b	1

	segment 'rom'

UART_init.w:
	;     UART  stm8s103f3
  bset	CLK_PCKENR1,	#3	; CLK_PCKENR1 |= 1<<3;
	;   TX
	bset	PC_DDR,	#5	; PC_DDR_bit.DDR5 = 1; //  
	bset	PC_CR1,	#5	; PC_CR1_bit.C15 = 1;  //  Push-pull
	bset	PC_CR2,	#5	; PC_CR2_bit.C25 = 0;  //  2
  ;   RX
	bset	PC_DDR,	#6	; PC_DDR_bit.DDR6 = 0; //  
	bset	PC_CR1,	#6	; PC_CR1_bit.C16 = 1;  //  Push-up
	bset	PC_CR2,	#6	; PC_CR2_bit.C26 = 0;  //  
  ;  - UART
  ; UART1_CR1_bit.M = 0; //    8 
  ; UART1_CR1_bit.PCEN = 0; //   (   - )
	mov		UART1_CR1, #$00
	mov		UART1_CR3, #$00		; UART1_CR3_bit.STOP = 0; // 1  
  ;mov		UART1_BRR2,	#$03	; UART1_BRR2 = 0x03; // : BRR2   BRR1
	;mov		UART1_BRR1, #$69	; UART1_BRR1 = 0x69; // 9600 kbps  16 MHz
  mov		UART1_BRR2,	#$00	; UART1_BRR2 = 0x00; // : BRR2   BRR1
	mov		UART1_BRR1, #$0D	; UART1_BRR1 = 0x0D; // 9600 kbps  2 MHz (9615.4 - 0,16%)
  bset	UART1_CR2, #3			; UART1_CR2_bit.TEN = 1; //  
	bset	UART1_CR2, #2			; UART1_CR2_bit.REN = 1; //  
	;mov		UART1_CR2, #$0C
	;   
	clr		XonXoff
	clr		save_count
	clr		save_total
	ret

putc.w:	;void putc(char c)
	cp		A,	#'\n'
	jrne  UART_putc
	ld		A,	#'\r'
	call	UART_putc
	ld		A,	#'\n'
UART_putc.w:	;void UART_putc(char c)
	btjf 	UART1_SR, #7, UART_putc	; while(!(UART1_SR & MASK_UART1_SR_TXE));
	ld		UART1_DR,	A							;  UART1_DR = c;
	ret

;puts.w:	;void puts(const char* str)
puts_1:
	ld		A,	(X)
	call	putc
	incw	X
puts.w:
	tnz		(X)
	jrne	puts_1
	ret

;puts.w:
;	ld		A,	(X)
;	jreq	puts_1
;	call	putc
;	incw	X
; jra		puts
;puts_1:
;	ret

getc.w		;char getc(void)	; Use: A, X; Result: X
  ;    ,  
  ;if(save_count < save_total)
  ;  return save_buffer[save_count++];
	ld		A,	save_count
	cp		A,	save_total
	jruge	getc_recive
	inc		save_count
	clrw	X
	ld		XL,	A
	addw	X,	#gets_save
	ld		A,	(X)
	ret
getc_recive:
  ;    
  ;if(!XonXoff)
	;  ,   
	tnz		XonXoff
	jrne	UATR_getc
  ;XonXoff = 1;
	inc		XonXoff
	;putc(XON);
	ld		A,	#$11
	call	putc
  ;save_total = save_count = 0;
	clr		save_total
	clr		save_count
  ;   
  ;return UART_getc();
	;jra	UATR_getc
UATR_getc.w		;char UART_getc()
	BTJF 	UART1_SR,	#5,	UATR_getc	; while(!(UART1_SR & MASK_UART1_SR_RXNE));
	LD		A,	UART1_DR						; return UART1_DR;
	ret


gets.w:		;char* gets(void)	; Use: A, X, Y; Result: X
	ldw		X,	#gets_buffer
gets_loop:
	ldw		Y,	X
	call	getc
	ldw		X,	Y
	;    
	cp		A,	#'\r'
	jreq	gets_loop_end
	cp		A,	#'\n'
	jreq	gets_loop_end
	;    	( c >= 32 && c < 127 )	; 127 - , 
	cp		A,	#32
	jrult	gets_loop_bad
	cp		A,	#127
	jrult	gets_loop_cpy
gets_loop_bad:
	;  
	ld		A,	#'\a'
	call	UART_putc
	jra		gets_loop
gets_loop_cpy:
	;    
	ld		(X),	A
	call	putc
gets_loop_inc:
	incw	X
	;   
	cpw		X,	#{gets_buffer + GETLINE_BUF_SIZE - 1}
	jrult	gets_loop
gets_loop_end:
  ;  
	clr		(X)
	;ld		A,	#'\r'
	;call	putc
	;ld		A,	#'\n'
	ld		A,	#'\t'
	call	putc
	;   
	;call	saveInput
	;  
	;ldw		X,	#gets_buffer
	;ret
saveInput:	;void saveInput(void)	;  A, X, Y
  ;  ,    
	;if(XonXoff)
	tnz		XonXoff
	jreq	saveInput_end
  ;  XonXoff = 0;
	clr		XonXoff
	;  putc(XOFF);
	ld		A,	#$13
	call	putc
  ;   ,      
	ldw		X,	#gets_save
	clr		save_total
saveInput_start:
	ldw		Y,	#GET_SAVETIMEOUT
saveInput_loop:
	decw	Y
	jreq	saveInput_end
  ;if(UART1_SR & MASK_UART1_SR_RXNE) read;
	btjf 	UART1_SR,	#5,	saveInput_loop
  ;    ,    
  ;save_buffer[save_total++] = UART1_DR;
	ld		A,	UART1_DR
	ld		(X),	A
	inc		save_total
	incw	X
  ;if(save_total < GET_SAVEBUF_SIZE) repeat;
	cpw		X,	#{gets_save + GETLINE_SAVE_SIZE}
	jrult	saveInput_start
saveInput_end:
	;  
	ldw		X,	#gets_buffer
	ret


	end
