stm8/

  #include "STM8S103F3P.inc"

	PUBLIC	unlock_PROG
	PUBLIC	unlock_DATA
	PUBLIC	lock_memory
	PUBLIC	Write_init
	PUBLIC	WriteMemory
	
	segment 'rom'

Store.w:	;	unsigned char WriteByte(const unsigned char* addr,	unsigned char data);
	;*((unsigned char*)addr)	= data;
	ld		(X),	A
	;dc.b	$F7
  ;while( (FLASH_IAPSR & (MASK_FLASH_IAPSR_EOP | MASK_FLASH_IAPSR_WR_PG_DIS)) == 0);
Store_wait:
	ld		A,	FLASH_IAPSR
	;dc.b	$C6, {high FLASH_IAPSR}, {low FLASH_IAPSR}
	and		A,	#$05
	;dc.b	$A4,	$05
	jreq	Store_wait
	;dc.b	$27,	$F9
	ret
	;dc.b	$81
Store_count	equ	{* - Store}

	segment 'ram1'

Store_in_RAM	ds.b	Store_count

	segment 'rom'

unlock_PROG.w
	; Unlock PROG memory
	mov		FLASH_PUKR,	#$56	; FLASH_PUKR = 0x56;
	mov		FLASH_PUKR,	#$AE	; FLASH_PUKR = 0xAE;
	ret
	
unlock_DATA.w
	; Unlock DATA memory !Keys are reversed on data memory!
	mov		FLASH_DUKR,	#$AE	; FLASH_DUKR = 0xAE;
	mov		FLASH_DUKR,	#$56	; FLASH_DUKR = 0x56;
	ret

lock_memory.w
	; Lock program memory
  bres	FLASH_IAPSR,	#1	; FLASH_IAPSR_bit.PUL = 0;//~0x02;
	; Lock data memory
  bres	FLASH_IAPSR,	#3;  FLASH_IAPSR_bit.DUL = 0;//~0x08;
	ret

Write_init:
	;     RAM
	clrw	X
WriteMemory_loop:
	;ld		A,	(#Store, X)
	dc.b	$D6, {high Store}, {low Store}
	;ld		(#Store_in_RAM, X),	A
	dc.b	$D7, {high Store_in_RAM}, {low Store_in_RAM}
	;dc.b	$E7, {low Store_in_RAM}
	incw	X
	cpw		X,	#Store_count
	jrult	WriteMemory_loop
	ret

WriteMemory:	;int WriteMemory(unsigned int base, const unsigned char* data, unsigned char len)
WriteMemory_bytes:
	; program remaining bytes
  ;while(len)
	tnz		A
	jreq	WriteMemory_end
	push	A
  ;  ret = WriteByte((void*) base, *data);
	ld		A,	(Y)
	call	Store_in_RAM
	;  if(ret == MASK_FLASH_IAPSR_WR_PG_DIS) break;
	cp		A,	#$01
	jreq	WriteMemory_pop_end	; Write disabled
  ;  base++;
  ;  data++;
  ;  len--;
	incw	X
	incw	Y
	pop		A
	dec		A
	jra		WriteMemory_bytes
WriteMemory_end:
  ;return len;
	ret
WriteMemory_pop_end:
	pop		A
	ret

	end
	