stm8/

	#include "mapping.inc"
  #include "STM8S103F3P.inc"
  #include "uart.inc"
  #include "prog.inc"

	; Comment next line to remove Dump support
	;#define	_DEBUG	1

stack_start.w EQU $stack_segment_start
stack_end.w EQU $stack_segment_end

; memory boundaries
RAM_START	equ	$0000
RAM_END		equ	$03FF
OPTION_START	equ	$4800
OPTION_END		equ	$480A
;UBC_OPTION_LOCATION	equ	$4801
;FLASH_START	equ	$8000
;FLASH_END 		equ	$9FFF
FLASH_START	equ	$8000
FLASH_END		equ	$9BFF
;FLASH_CLEAR_BYTE	equ	$A5
EEPROM_START	equ	$4000
EEPROM_END		equ	$427F
;EEPROM_END	equ	$407F

BOOTV_START	equ	$8000
BOOTV_END		equ	$8003

;RESET_VECTOR_ADDR	equ	$9FFC

	segment 'ram0'

; ,  
;unsigned char len; //ProcessHEX, WriteAnyMemory
len.b			ds.b	1
;unsigned char len; //ProcessHEX
sum.b			ds.b	1
;unsigned int addr, data, wlen; //WriteAnyMemory
addr.b	ds.w	1
data.b	ds.w	1
wlen.b	ds.w	1

	segment 'rom'

RESET_VECTOR_ADDR	dc.l	$FFFFFFFF

main.l
	; initialize SP
	ldw X,#stack_end
	ldw SP,X

	;    (Fsys = Fosc = 16MHz)
	;mov		CLK_CKDIVR, #$00	; CLK_CKDIVR = 0;
	;clr	A
	;ld	CLK_CKDIVR, A
	
  ;   
	#ifdef _DEBUG
  bres	PD_DDR,	#2	; PD_DDR_bit.DDR2 = 0; //  
  bset	PD_CR1,	#2	; PD_CR1_bit.C12 = 1;  //   Pull-up
  bres	PD_CR2,	#2	; PD_CR2_bit.C22 = 0;  //  
;  if( (PD_IDR & MASK_PD_IDR_IDR2) && ( *((const unsigned char*)RESET_VECTOR_ADDR) == 0x82) )
  btjf	PD_IDR,	#2,	main_boot
	#else
  bres	PD_DDR,	#1	; PD_DDR_bit.DDR2 = 0; //  
  bset	PD_CR1,	#1	; PD_CR1_bit.C12 = 1;  //   Pull-up
  bres	PD_CR2,	#1	; PD_CR2_bit.C22 = 0;  //  
;  if( (PD_IDR & MASK_PD_IDR_IDR1) && ( *((const unsigned char*)RESET_VECTOR_ADDR) == 0x82) )
  btjf	PD_IDR,	#1,	main_boot
	#endif ;_DEBUG
	ld		A,	RESET_VECTOR_ADDR
  cp		A,	#$82
  jrne	main_boot
;    run();
	jp		run
main_boot:
	call	Write_init
	call	UART_init;	UART_init();
	ldw		X,	#hello_str
main_put_and_loop:
	call	puts
	ldw		X,	#end_str
	call	puts
main_loop:
	call	gets
	call	lower
	ld		A,	(X)
main_is_quit:
	cp		A,	#'q'
	jrne	main_is_flash
  ;if( 0x82 == *RESET_VECTOR_ADDR ) break;	// quit
	ld		A,	RESET_VECTOR_ADDR
  cp		A,	#$82
  jreq	main_loop_end
  ;    puts("Firmware missed.");
	ldw		X,	#fware_str
	jra		main_put_and_loop
main_is_flash:
	cp		A,	#':'
	jrne	main_is_dump
  ;if( ProcessWrite((unsigned char*)str) )
	; puts("Error duaring process.\n");
	;else
  ; puts("Ok.\n");
	call	ProcessHEX
	ldw		X,	#ok_str
	TNZ		A
	jreq	main_put_and_loop
	ldw		X,	#error_str
	jra		main_put_and_loop
main_is_dump:
	#ifdef _DEBUG
	cp		A,	#'d'
	jrne	main_wrong
	call	DumpEEPROM
	ldw		X,	#ok_str
	jra		main_put_and_loop
	#endif ;_DEBUG
main_wrong:
	;puts("Wrong token. Only f|d|q|r|o|: allowed.\n");
	ldw		X,	#wrong_str
	jra		main_put_and_loop
main_loop_end:
	;call deinit
	;call run
;foreverloop
	;jra foreverloop
	; Deinitialize used resources
deinit.w
	call	lock_memory			; lock_memory();
	clr		A
	;mov		PC_ODR,	#$00	; PC_ODR=0x00;
	;mov		PC_DDR,	#$00	; PC_DDR=0x00;
	;mov		PC_CR1,	#$00	; PC_CR1=0x00;
	;mov		PC_CR2,	#$00	; PC_CR2=0x00;
	;ld		PC_ODR,	A
	ld		PC_DDR,	A
	ld		PC_CR1,	A
	ld		PC_CR2,	A
	;mov		UART1_CR3,	#$00	; UART1_CR3 = 0;
	;mov		UART1_CR1,	#$00	; UART1_CR1 = 0;
	;mov		UART1_CR2,	#$00	; UART1_CR2 = 0;
	;mov		UART1_BRR2,	#$00	; UART1_BRR2 = 0;
	;mov		UART1_BRR1,	#$00	; UART1_BRR1 = 0;
	ld		UART1_CR3,	A
	ld		UART1_CR1,	A
	ld		UART1_CR2,	A
	ld		UART1_BRR2,	A
	ld		UART1_BRR1,	A
	;   
	ld		A,	UART1_SR
	ld		A,	UART1_DR
	;ret
	; Run 
run.w
  ;mov	PD_ODR,	#0	; PD_ODR=0x00;
  ;mov	PD_DDR,	#0	; PD_DDR=0x00;
  ;mov	PD_CR1,	#0	; PD_CR1=0x00;
  ;mov	PD_CR2,	#0	; PD_CR2=0x00;
	#ifdef _DEBUG
  ;bres	PD_ODR,	#2
  ;bres	PD_DDR,	#2
  bres	PD_CR1,	#2
  ;bres	PD_CR2,	#2
	#else
  ;bres	PD_ODR,	#1
  ;bres	PD_DDR,	#1
  bres	PD_CR1,	#1
  ;bres	PD_CR2,	#1
	#endif ;_DEBUG
	;mov		CLK_CKDIVR, #$18	; CLK_CKDIVR = 0x18;
	ldw		X,	SP
	ld		A,	#$ff
	ld		XL,	A
	LDW		SP,	X
	jp		RESET_VECTOR_ADDR
  ;ldw X,#stack_end
  ;ldw SP,X
  ;jpf reset_vector_save
  ;jra run
	;ret

lower		; char* lower(char* str);
	;ldw		Y,	X	; 1,2	- cicle,size
	pushw	X		; 2,1
lower_start:
	ld		A,	(X)
	jreq	lower_end
	cp		A,	#'A'
	jrult	lower_inc
	cp		A,	#'Z'
	jrugt	lower_inc
	sub		A,	#{'A' - 'a'}
	ld		(X),	A
lower_inc:
	incw	X
	jra		lower_start
lower_end:
	;ldw		X,	Y	; 1,1
	popw	X		; 2,1
	ret

	#ifdef _DEBUG

;void DumpMemory(unsigned int addr, int count)
;{
;  int i;
;  for(i = 0; i < count; ++i)
;  {
;    if(!(i & 0x0f) )
;    {
;      if(i)
;      {
;        puts("\n");
;      }
;      putVar(addr + i);
;    }
;    putc(' ');
;    putHex(*(char*)(addr + i));
;  }
;  puts("\n");
;}

;const char* hexsyms = "0123456789ABCDEF";
;void putHex(char data)
;{
;  putc(hexsyms[(data>>4)&0x0F]);
;  putc(hexsyms[(data)&0x0F]);
;}

putHex
	push	A
	swap	A
	call	putHex1
	pop		A
putHex1:
	and		A,	#$0F
	cp		A,	#10
	jrult	putHex1_out
	add		A,	#{'A' - '0' - 10}
putHex1_out:
	add		A,	#'0'
	jp		putc

DumpEEPROM
	ldw		X,	#EEPROM_START
dump_loop:
	ld		A,	XL
	and		A,	#$0F
	jrne	dump_byte
	ld		A,	#'\n'
	call	putc
	ld		A,	XH
	call	putHex
	ld		A,	XL
	call	putHex
dump_byte:
	ld		A,	#' '
	call	putc
	ld		A,	(X)
	call	putHex
	incw	X
	cpw		X,	#EEPROM_END
	jrule	dump_loop
	ld		A,	#'\n'
	call	putc
	ret

	#endif ;_DEBUG

;  addr, buff, len, sum

hex2bin	;	unsigned char hex2bin(char c)	;  A
  ;if(c >= '0' && c <= '9') return c - '0';
	cp		A,	#'0'
	jrult	hex2bin_err
	cp		A,	#'9'
	jrugt	hex2bin_is_sym
	sub		A,	#'0'
	ret
hex2bin_is_sym:	
  ;//else if(c >= 'A' && c <= 'F') return c - 'A' + 10;
  ;else if(c >= 'a' && c <= 'f') return c - 'a' + 10;
	cp		A,	#'a'
	jrult	hex2bin_err
	cp		A,	#'f'
	jrugt	hex2bin_err
	sub		A,	#{'a' - 10}
	ret
hex2bin_err:
	ld		A,	#$FF
	ret

;// unsigned c; c -= '0'; if(c <= 9) return c; c -= 'A' - '0'; if(c <= 6) return c + 10; c -= 'a' - 'A'; if(c <= 6) return c + 10; return -1;

inplaceHex2Array	;	int inplaceHex2Array(unsigned char* buffer, unsigned char* sum)	;  A, X, Y, len, sum
  ;int count = 0;
  ;unsigned char* dst = buffer;
  clr		len
  clr		sum
	ldw		Y,	X
inplaceHex2Array_loop:
  ;while(1) {//*buffer)
  ;  int val;
  ;  val = hex2int(*buffer++);
	ld		A,	(X)
	jreq	inplaceHex2Array_end
	call	hex2bin
	incw	X
  ;  if(val < 0) break; // for correct end of line detecting
	cp		A,	#$FF
	jreq	inplaceHex2Array_err
  ;  *dst = val<<4;
	swap	A
	ld		(Y),	A
  ;  val = hex2int(*buffer++);
	ld		A,	(X)
	call	hex2bin
	incw	X
  ;  if(val < 0) return -1;
	cp		A,	#$FF
	jreq	inplaceHex2Array_err
  ;  *dst |= val;
	or		A,	(Y)
	ld		(Y),	A
  ;  if(sum) sum += *dst;
	add		A,	sum
	ld		sum,	A
  ;  dst++;
  ;  count++;
	incw	Y
	inc		len
  jra		inplaceHex2Array_loop
inplaceHex2Array_end:
  ;return count;
	ld		A,	len
	ret
inplaceHex2Array_err:
	clr		A
	ret

ProcessHEX		;bool	ProcessHEX(char* buffer);
;{
  ;int n;
  ;unsigned char sum = 0;
  ;//if(buff[0] != ':') return -1;
  ;  HEX    
  ;n = inplaceHex2Array(buff + 1, &sum);	//   ':'  .
	incw	X
	;ldw		Y,	X	; 1,2	- cicle,size
	pushw	X		; 2,1
	call	inplaceHex2Array
	;ldw		X,	Y	; 1,1
	popw	X		; 2,1
	
  ;     (    5       )
  ;if(n < 5 || (n - 5) != buff[1])
  ;{
  ;  //xprintf("HEX: broken line\n");
  ;  return -1;
  ;}
	cp		A,	#5
	jrult	ProcessWrite_err
	sub		A,	#5
	cp		A,	(X)
	jrne	ProcessWrite_err
	;  
	ld		len,	A
	incw	X
	
  ;   
  ;if(sum)
  ;{
  ;  //xprintf("HEX: wrong CRC token 0x%02x instead of 0x%02x\n", buff[n], (sum - buff[n])&0x00FF);
  ;  return -1;
  ;}
	tnz		sum
	jrne	ProcessWrite_err
	
	;    
	ldw		Y,	X
	ldw		Y,	(Y)
	incw	X
	incw	X
	
	;   
	ld		A,	(X)
	;    
  ;if(buff[4] == 1)
	cp		A,	#1
	jreq	ProcessWrite_ok
  ;    
  ;if(buff[4] == 5)
	cp		A,	#5
	jreq	ProcessWrite_ok
  ;    
  ;if(!buff[4])
	tnz		A
	jrne	ProcessWrite_err
	incw	X
  ;    
  ;return WriteAnyMemory((((unsigned int)buff[2]) << 8) | buff[3], &buff[5], buff[1]);//n - 5);
	exgw	X,	Y
	ld		A,	len
	call	WriteAnyMemory
	ret
ProcessWrite_err:
	ld		A,	#1
	ret
ProcessWrite_ok:
	clr		A
	ret

WriteAnyMemory	;	int WriteAnyMemory(unsigned int addr, const unsigned char *data, unsigned int count)
	ldw		addr,	X
	ldw		data,	Y
	clrw	Y
	ld		YL,	A
	ldw		wlen,	Y
	;clr		#{high wlen}
	;ld		#{low wlen},	A
	;ldw		Y,	wlen
	addw	Y,	addr
	decw	Y
  ;   
  ;if(addr >= FLASH_START && addr + count - 1 <= FLASH_END)
	cpw		X,	#FLASH_START
	jrult	write_not_Flash
	cpw		Y,	#FLASH_END
	jrugt	write_not_Flash
	;	  
	call	unlock_PROG
	;      
	;  if(!(addr >= BOOTV_END || addr + count - 1 <= BOOTV_START) )
	cpw		X,	#BOOTV_END
	jrugt	write_Flash
  ;      
  ;    //if(addr == BOOTV_START)
  ;    //{
  ;    //  // ,       
  ;    //  if(&buff[1] != 0x82)
  ;    //  {
  ;    //    return -1;
  ;    //  }
  ;    //}
  ;    ////     -     
  ;     
	addw	X,	#{RESET_VECTOR_ADDR - BOOTV_START}
	;  int nn, ret;
	;  nn = (BOOTV_END - addr + 1);	// ,         
	ldw		Y,	#{BOOTV_END + 1}
	subw	Y,	addr
	;  if(nn >= count)	//     ,      
	cpw		Y,	wlen
	jruge	write_Flash
	;    ,   
	;1: addr + const,	data,	YL
	;2: const,	data + YL,	len - YL
	;jp	WriteAnyMemory_err	; DEBUG
  ;  ret = WriteMemory(RESET_VECTOR_ADDR + (addr - BOOTV_START), data, nn);
	ldw		addr,	Y		; addr        
	ld		A,	YL
	ldw		Y,	data
	call	WriteMemory
  ;  if(ret > 0) return ret;
	tnz		A
	jrne	WriteAnyMemory_err
	; !   e Y ,  X - RESET_VECTOR_ADDR + 4,  A - 0.
	ldw		X,	#{BOOTV_END + 1}
	;ldw		Y,	wlen
	;subw	Y,	addr	;     
	;ld		A,	YL
	ld		A,	#{low wlen}
	sub		A,	#{low addr}	;     
	;ldw		Y,	addr	;     
	;addw	Y,	data
	jra		write_Flash_no_restore
  ;     
	;  if(count > nn)
	;  {
  ;    ret = WriteMemory(addr + nn, data + nn, count - nn);
  ;    //ret = WriteMemory(BOOTV_END + 1, &buff[5] + nn, count - nn);
  ;    if(ret > 0) return ret;
  ;  }
	;  return 0;
write_Flash:
  ;   ,   
  ;    return WriteMemory(addr, data, count);//buff[0]);
	ldw		Y,	data
write_Flash_no_restore:
	call	WriteMemory
	call	lock_memory
	ret
write_not_Flash:
  ;else if(addr >= EEPROM_START && addr + count - 1 <= EEPROM_END)
  ;{
  ;  //   
  ;  return WriteMemory(addr, data, count);
  ;}
	cpw		X,	#EEPROM_START
	jrult	write_not_EEPROM
	cpw		Y,	#EEPROM_END
	jrugt	write_not_EEPROM
	call	unlock_DATA
	ldw		Y,	data
	call	WriteMemory
	call	lock_memory
	ret
write_not_EEPROM:
  ;//else if(addr >= RAM_START && addr + count - 1 <= RAM_END) //     ,   
  ;//{
  ;//  //   
  ;//    int i;
  ;//    for(i = 0; i < count; ++i)
  ;//      ((unsigned char*)addr)[i] = data[i];
  ;//}
  ;//else if(addr >= OPTION_START && addr + count - 1 <= OPTION_END)
  ;//{
  ;//  //   
  ;//  for(i=0; i<DataCount; i++)
  ;//  {
  ;//     FLASH_ProgramOptionByte((u32)(&DataAddress[i]), DataBuffer[i]);
  ;//  }
  ;//}
  ;//  
  ;return -1;
WriteAnyMemory_err:
	ld		A,	#$FF
	ret

	segment 'rom'

hello_str:	dc.b	"STM8 ASM TopFlash bootloader (q - quit)", '\0'
fware_str:	dc.b	"Firmware missed", '\0'
error_str:	dc.b	"Error duaring process", '\0'
wrong_str:	dc.b	"Wrong format", '\0'
ok_str:			dc.b	"Ok", '\0'
end_str:		dc.b	'.', '\n', '\0'

	segment 'rom'
;	interrupt NonHandledInterrupt
;NonHandledInterrupt.l
;	iret

	segment 'vectit'

	dc.l {$82000000+main}									; reset
;	dc.l {$82000000+NonHandledInterrupt}	; trap
;	dc.l {$82000000+NonHandledInterrupt}	; irq0
;	dc.l {$82000000+NonHandledInterrupt}	; irq1
;	dc.l {$82000000+NonHandledInterrupt}	; irq2
;	dc.l {$82000000+NonHandledInterrupt}	; irq3
;	dc.l {$82000000+NonHandledInterrupt}	; irq4
;	dc.l {$82000000+NonHandledInterrupt}	; irq5
;	dc.l {$82000000+NonHandledInterrupt}	; irq6
;	dc.l {$82000000+NonHandledInterrupt}	; irq7
;	dc.l {$82000000+NonHandledInterrupt}	; irq8
;	dc.l {$82000000+NonHandledInterrupt}	; irq9
;	dc.l {$82000000+NonHandledInterrupt}	; irq10
;	dc.l {$82000000+NonHandledInterrupt}	; irq11
;	dc.l {$82000000+NonHandledInterrupt}	; irq12
;	dc.l {$82000000+NonHandledInterrupt}	; irq13
;	dc.l {$82000000+NonHandledInterrupt}	; irq14
;	dc.l {$82000000+NonHandledInterrupt}	; irq15
;	dc.l {$82000000+NonHandledInterrupt}	; irq16
;	dc.l {$82000000+NonHandledInterrupt}	; irq17
;	dc.l {$82000000+NonHandledInterrupt}	; irq18
;	dc.l {$82000000+NonHandledInterrupt}	; irq19
;	dc.l {$82000000+NonHandledInterrupt}	; irq20
;	dc.l {$82000000+NonHandledInterrupt}	; irq21
;	dc.l {$82000000+NonHandledInterrupt}	; irq22
;	dc.l {$82000000+NonHandledInterrupt}	; irq23
;	dc.l {$82000000+NonHandledInterrupt}	; irq24
;	dc.l {$82000000+NonHandledInterrupt}	; irq25
;	dc.l {$82000000+NonHandledInterrupt}	; irq26
;	dc.l {$82000000+NonHandledInterrupt}	; irq27
;	dc.l {$82000000+NonHandledInterrupt}	; irq28
;	dc.l {$82000000+NonHandledInterrupt}	; irq29

	end
