#include "iostm8s103f3.h"

#define BEEP_TONE_OFF 0x1F
#define BEEP_TONE_LO  0x1D
#define BEEP_TONE_HI  0x10

void BEEP_init();
void BEEP_tone(unsigned char tone);
void BEEP_enable(unsigned char enable);

void BEEP_init(void)
{
  //  
  BEEP_CSR_bit.BEEPDIV = 0x1D;
  BEEP_CSR_bit.BEEPEN = 0;
  BEEP_CSR_bit.BEEPSEL = 0;
  //  
  PD_DDR_bit.DDR4 = 1;
  PD_CR1_bit.C14 = 1;
  //PD_CR2_bit.C24 = 0; //  
}

void BEEP_enable(unsigned char enable)
{
  BEEP_CSR_bit.BEEPEN = enable;
}

void BEEP_tone(unsigned char tone)
{
  BEEP_CSR_bit.BEEPDIV = tone;
}

void UART_init()
{
  CLK_PCKENR1 |= 1<<3;  //     UART  stm8s103f3
  
  PC_DDR_bit.DDR5 = 1; // TX
  PC_CR1_bit.C15 = 1;  //   Push-pull
  PC_CR2_bit.C25 = 0;  //   -  2 .
  
  PC_DDR_bit.DDR6 = 0; // RX
  PC_CR1_bit.C16 = 1;  //   Push-up
  PC_CR2_bit.C26 = 0;  //  
  
  UART1_CR1_bit.M     = 0;  //    8 
  UART1_CR1_bit.PCEN  = 0;  //    (   - )
  UART1_CR3_bit.STOP  = 0;  // 1  
  UART1_BRR2  = 0x03;       // : BRR2   BRR1
  UART1_BRR1  = 0x69;       // 9600 kbps  16 MHz
  UART1_CR2_bit.TEN   = 1;  //  
  UART1_CR2_bit.REN   = 1;  //  
}

char getc() {
    char c;
    while(!(UART1_SR & MASK_UART1_SR_RXNE));  // UART1 mask have wrong bit description
    c = UART1_DR;
    return c;
}

void putc(char c) {
    while(!(UART1_SR & MASK_UART1_SR_TXE));
    UART1_DR = c;
}

void puts(const char* str)
{
  while(*str)
    putc(*str++);
}

void _delay_ms(int ms) {
  char i, j;
  while(ms--)
    for(i = 12; i; --i)
      for(j = 255; j; --j)
        asm("nop");
}

// ---   ---

int main( void )
{
  CLK_CKDIVR  = 0;  //  HSE       
  BEEP_init();
  UART_init();
  puts("Test program #2 Sound\r\n");
  while(1) {
    BEEP_enable(1);
    BEEP_tone(BEEP_TONE_LO);
    _delay_ms(300);
    BEEP_tone(BEEP_TONE_HI);
    _delay_ms(300);
    BEEP_tone(BEEP_TONE_LO);
    _delay_ms(300);
    BEEP_tone(BEEP_TONE_HI);
    _delay_ms(300);
    BEEP_tone(BEEP_TONE_LO);
    _delay_ms(300);
    BEEP_tone(BEEP_TONE_HI);
    _delay_ms(300);
    BEEP_enable(0);
    _delay_ms(300);
  }
  return 0;
}
