#include "iostm8s103f3.h"

void UART_init()
{
  CLK_PCKENR1 |= 1<<3;  //     UART  stm8s103f3
  
  PC_DDR_bit.DDR5 = 1; // TX
  PC_CR1_bit.C15 = 1;  //   Push-pull
  PC_CR2_bit.C25 = 0;  //   -  2 .
  
  PC_DDR_bit.DDR6 = 0; // RX
  PC_CR1_bit.C16 = 1;  //   Push-up
  PC_CR2_bit.C26 = 0;  //  
  
  UART1_CR1_bit.M     = 0;  //    8 
  UART1_CR1_bit.PCEN  = 0;  //    (   - )
  UART1_CR3_bit.STOP  = 0;  // 1  
  UART1_BRR2  = 0x03;       // : BRR2   BRR1
  UART1_BRR1  = 0x69;       // 9600 kbps  16 MHz
  UART1_CR2_bit.TEN   = 1;  //  
  UART1_CR2_bit.REN   = 1;  //  
}

// ---   ---

char getc() {
    char c;
    while(!(UART1_SR & MASK_UART1_SR_RXNE));  // UART1 mask have wrong bit description
    c = UART1_DR;
    return c;
}

void putc(char c) {
    while(!(UART1_SR & MASK_UART1_SR_TXE));
    UART1_DR = c;
}

void puts(const char* str)
{
  while(*str)
    putc(*str++);
}

void _delay_ms(int ms) {
  char i, j;
  while(ms--)
    for(i = 12; i; --i)
      for(j = 255; j; --j)
        asm("nop");
}

// ---   ---

int main( void )
{
  CLK_CKDIVR  = 0;              //   
  PD_ODR_bit.ODR3 = 0;
  PD_DDR_bit.DDR3 = 1;
  PD_CR1_bit.C13 = 1;
  PD_CR2_bit.C23 = 0;
  UART_init();
  puts("Test program #1 Blink\r\n");
  while(1) {
    putc('H');
    PD_ODR_bit.ODR3 = 1;
    _delay_ms(500);
    putc('L');
    PD_ODR_bit.ODR3 = 0;
    _delay_ms(500);
  }
  return 0;
}
