#include "web_if.h"

char* utoa(unsigned int value, unsigned char base);
void putString(const char* str);
void putUInt(unsigned int value, unsigned char base);

const char webif_404_reply[] =
	"HTTP/1.0 404 Not Found\r\n"
	"Content-Type: text/html; charset=windows-1251\r\n"
	"Server: STM8S105C6\r\n"
	"\r\n"
	"<pre>Page not found\r\n\r\n"
	"<a href='/'>Home page</a></pre>\r\n";

const char webif_200_header[] =
	"HTTP/1.0 200 OK\r\n"
	"Content-Type: text/html; charset=windows-1251\r\n"
	"Server: STM8S105C6\r\n"
	"\r\n";

uint8_t led_brightness;

void fill_buf(char **buf, const char *pstr)
{
	char c;
	while((c = *pstr++))
		*((*buf)++) = c;
}

void webif_init()
{
	// Fast PWM
	//DDRB |= (1<<PB2)|(1<<PB3);
	//TCCR0 = (1<<WGM01)|(1<<WGM00)|(1<<COM01)|(1<<COM00)|(1<<CS02);
}

void webif_data(uint8_t id, eth_frame_t *frame, uint16_t len)
{
	ip_packet_t *ip = (void*)(frame->data);
	tcp_packet_t *tcp = (void*)(ip->data);
	char *req = (void*)tcp_get_data(tcp);
	char *buf = (void*)(tcp->data), *buf_ptr = buf;
	char *url, *p, *params, *name, *value;
	int val;

	if(!len) return;

	if( (memcmp(req, "GET ", 4) == 0) &&
		((p = strchr(req + 4, ' ')) != 0) )
	{
		url = req + 4;
		*p = 0;

		if((params = strchr(url, '?')))
			*(params++) = 0;

		if(strcmp(url, "/") == 0)
		{
			while(params)
			{
				if((p = strchr(params, '&')))
					*(p++) = 0;
				
				name = params;
				if((value = strchr(name, '=')))
					*(value++) = 0;
				
				if( (strcmp(name, "pwm") == 0 ) && value )
				{
					val = atoi(value);
					if(val < 0) val = 0;
					if(val > 255) val = 255;
					led_brightness = val;
					
					//OCR0 = led_brightness;
					putString("WEBIF set brightness to ");
					putUInt(led_brightness, 10);
					putString("\r\n");
				}
				
				params = p;
			}

			

			fill_buf(&buf_ptr, webif_200_header);
			fill_buf(&buf_ptr, "<pre>Brightness: ");
			fill_buf(&buf_ptr, utoa(led_brightness, 10));
			fill_buf(&buf_ptr, ". <a href='/edit'>Change</a></pre>");
		}

		else if(strcmp(url, "/edit") == 0)
		{
			fill_buf(&buf_ptr, webif_200_header);
			fill_buf(&buf_ptr,	\
				"<pre>"		\
				"<form action='/' method='GET'>\r\n"	\
				"Enter value (0..255):\r\n" \
				"<input type='text' name='pwm' size='4' value='");
			fill_buf(&buf_ptr, utoa(led_brightness, 10));
			fill_buf(&buf_ptr,
				"'>  "		\
				"<input type='submit' value='OK'>\r\n"	\
				"</form>"	\
				"</pre>");
		}

		else
		{
			fill_buf(&buf_ptr, webif_404_reply);
		}
	}

	tcp_send(id, frame, buf_ptr-buf, 1);
}
