#include "iostm8.h"
#include "uart.h"
#include "intrinsics.h"

void _delay_ms(int ms) {
  char i, j;
  while(ms--)
    for(i = 12; i; --i)
      for(j = 255; j; --j)
        asm("nop");
}

char* utoa(unsigned int value, unsigned char base) {
        static char buff[16];
        char *str;
        str = &buff[sizeof(buff) - 1];
        *str = 0;
	if(value == 0) {
		*--str = '0';
	} else {
		unsigned int left;
		while(value && str > buff) {
			left = value % base;
			value = value / base;
			*--str = left + (left < 10 ? '0' : 'A' - 10);
		}
	}
	return str;
}

void putString(const char* str)
{
  unsigned char len;
  for(len = 0; str[len]; ++len);
  UART_write(str, len);
}

void putUInt(unsigned int value, unsigned char base)
{
	putString(utoa(value, base));
}

void HSE_init()
{
  CLK_ECKR_bit.HSEEN  = 1;
  while(!CLK_ECKR_bit.HSERDY);
  CLK_SWCR_bit.SWEN   = 1;
  CLK_SWR     = 0xB4;
  CLK_CKDIVR  = 0;
  while(!CLK_SWCR_bit.SWIF);
  CLK_SWCR_bit.SWIF   = 0;
}

#include <stdlib.h>
#include "lan.h"
#include "counter.h"
#include "web_if.h"

void init()
{
  PA_ODR = 0x08;
  PA_DDR = 0x08;
  PA_CR1 = 0x08;
  PA_CR2 = 0x08;
  
  PC_ODR = 0x10;
  PC_DDR = 0x70;
  PC_CR1 = 0x70;
  PC_CR2 = 0x70;
  
  PD_ODR = 0x21;
  PD_DDR = 0x21;
  PD_CR1 = 0x21;
  PD_CR2 = 0x21;

  HSE_init();
  UART_init();
  putString("\r\nSTM8S105C6 WEB server\r\n" \
            "Init HSE\r\nInit UART\r\nInit Lan\r\n");
  _delay_ms(20);
  lan_init();
  counter_init();
  putString("Init WEBIF\r\n");
  webif_init();
}

void udp_packet(eth_frame_t *frame, uint16_t len)
{
  putString("UDP packet\r\n");
}

uint8_t tcp_listen(uint8_t id, eth_frame_t *frame)
{
  putString("TCP Listen\r\n");
	ip_packet_t *ip = (void*)(frame->data);
	tcp_packet_t *tcp = (void*)(ip->data);

	if( (tcp->to_port == htons(80)) ||
		(tcp->to_port == htons(44444)) )
	{
		return 1;
	}
	return 0;
}

void tcp_opened(uint8_t id, eth_frame_t *frame)
{
  putString("TCP open\r\n");
}

void tcp_closed(uint8_t id, uint8_t reset)
{
  putString("TCP close\r\n");
}

void tcp_data(uint8_t id, eth_frame_t *frame, uint16_t len, uint8_t closing)
{
  putString("TCP data\r\n");
	webif_data(id, frame, len);
}

int main( void )
{
  init();
  putString("Polling lan\r\n");
  while(1) {
    lan_poll();
    if(lan_up()) {
      PD_ODR_bit.ODR2 = 0;
    } else {
      PD_ODR_bit.ODR2 = 1;
    }
    void counter_add(void);
    counter_add();
  }
  return 0;
}

