//---------------------------------------------------------------------------

#include <vcl.h>
#include <stdio.h>
#pragma hdrstop

//---------------------------------------------------------------------------

#pragma argsused

int main(int argc, char* argv[])
{
    int ret = 3;
    const char* fname = "intro.bmp";
    const char* fbinname = "out.bin";
    const char* fsrcname = "out.src";
    const char* fasmname = "out.asm";
    int width, height, rows, count;
    int asmbase = 0xA000;
    Graphics::TBitmap *bitmap = NULL;
    FILE *fasm = NULL;
    FILE *fsrc = NULL;
    FILE *fbin = NULL;
    if(argc > 1) fname = argv[1];
    try
    {
        printf("File\t: %s\n", fname);
        bitmap = new Graphics::TBitmap();
        bitmap->LoadFromFile(fname);
        width = bitmap->Width;
        height = bitmap->Height;
        rows = (height + 7) / 8;
        // Output files
        fbin = fopen(fbinname, "wb");
        if(!fbin) throw Exception("Can't open output binary file");
        fsrc = fopen(fsrcname, "wt");
        if(!fsrc) throw Exception("Can't open output source file");
        fasm = fopen(fasmname, "wt");
        if(!fasm) throw Exception("Can't open output assembler file");
        // Console
        printf("Width\t: %d\n", width);
        printf("Height\t: %d\n", height);
        printf("Rows\t: %d\n", rows);
        printf("Output Files:\n");
        printf(" Binary    : %s\n", fbinname);
        printf(" C source  : %s\n", fsrcname);
        printf(" Assembler : %s\n", fasmname);
        printf("Convert ");
        // C source
        fprintf(fsrc, "// Image file : %s\n", fname);
        fprintf(fsrc, "// Width      : %d\n", width);
        fprintf(fsrc, "// Height     : %d\n", height);
        fprintf(fsrc, "// Rows       : %d\n", rows);
        fprintf(fsrc, "unsigned char image[%d] = {\n", rows*width);
        // Assembler stm8
        fprintf(fasm, "stm8/\n\n\tWORDS\n\tsegment byte at ");
        fprintf(fasm, "%04X-%04X", asmbase, asmbase + rows*width - 1);
        fprintf(fasm, " 'logo'\n\n\tsegment 'logo'\n\n");
        fprintf(fasm, "; File   : %s\n", fname);
        fprintf(fasm, "; Width  : %d\n", width);
        fprintf(fasm, "; Height : %d\n", height);
        fprintf(fasm, "; Rows   : %d\n", rows);
        fprintf(fasm, "; Bytes  : %d\n", rows*width);
        fprintf(fasm, "\nimage");
        // process
        count = 0;
        printf("[");
        for(int i = 0; i < rows; ++i) {
            for(int j = 0; j < width; ++j) {
                unsigned char d = 0;
                for(int k = 0; k < 8; ++k) {
                    TColor c = (i*8+k < height)
                                ? bitmap->Canvas->Pixels[j][i*8+k]
                                : clWhite
                                ;
                    bool dark =  ( true
                            && GetRValue(c) < 128
                            && GetGValue(c) < 128
                            && GetBValue(c) < 128
                            );
                    d >>= 1;
                    d |= (dark) ? 0x80 : 0;
                }
                fwrite(&d, 1, 1, fbin);
                fprintf(fsrc, " 0x%02x,", d);
                if(!(width%8)) fprintf(fsrc, "\n");
                fprintf(fasm, "%s $%02x", (count%8) ? "," : "\n\tdc.b", d);
                count++;
            }
            if(width%8) fprintf(fsrc, "\n");
            printf("*");
        }
        printf("]");
        fprintf(fasm, "\n\tend\n");
        fflush(fasm);
        fprintf(fsrc, "};\n", rows);
        fflush(fsrc);
        fflush(fbin);
        printf(" Complite %d bytes\n", count);
        ret = 0;
    }
    catch (Exception &exception)
    {
        fprintf(stderr, "\nError: %s\n", exception.Message.c_str());
        ret = 1;
    }
    catch (...)
    {
        fprintf(stderr, "\nError: Unhandled exception\n");
        ret = 2;
    }
    if(fasm) fclose(fasm);
    if(fsrc) fclose(fsrc);
    if(fbin) fclose(fbin);
    delete bitmap;
    Sleep(1000);
    return ret;
}
//---------------------------------------------------------------------------
 