//============================================================================
// Name        : settings2_test.cpp
// Author      : plBots@yandex.ru
// Version     : 0.1
// Copyright   : CC0
// Description : Test Settings classes
//============================================================================

#include <iostream>

#include "Settings.h"

using namespace std;
using namespace ESD::Settings;

template <class T>
void GetVal(ISettings& settings, const std::string& key) {
	Getter cfg(&settings);
	cout << " Get '" << key << "': ";
	cout << "  result: '" << cfg.Get(key, T()) << "'";
	cout << endl;
}

template <class T>
void SetVal(ISettings& settings, const std::string& key, T newVal) {
	Accessor cfg(&settings);
	cout << " Set '" << key << "' to '" << newVal << "': ";
	cout << "  before: '" << cfg.Get(key, T()) << "'";
	cout << "  return: '" << cfg.Set(key, newVal) << "'";
	cout << "  after: '" << cfg.Get(key, T()) << "'";
	cout << endl;
}

template <>
void SetVal<const char*>(ISettings& settings, const std::string& key, const char* newVal) {
	SetVal(settings, key, string(newVal?newVal:""));
}

void UnsetVal(ISettings& settings, const std::string& key) {
	Accessor cfg(&settings);
	cout << " Unset '" << key << "': ";
	cout << "  before: '" << cfg.Get(key, "") << "'";
	cout << "  return: '" << cfg.Unset(key) << "'";
	cout << "  after: '" << cfg.Get(key, "") << "'";
	cout << endl;
}

const char* cfgFile = "esd.cfg";

// cache	- хранит значения в памяти
// load from file	- загружает значения из файла (возможно отдельный класс)
// group proxy	- все запросы переадресует в выбранную группу (group + parent)
// write proxy	- добавляемые значения сохраняются в памяти этого объекта (cache + parent)
// ignore write proxy	- все попытки записи значений игнорируются (parent)

int main(int argc, char** argv) {
	if(argc > 1) {
		cfgFile = argv[1];
	}

	cout << "Create map1" << endl;
	SettingsMap map1;
	SetVal(map1, "name", "map");
	SetVal(map1, "id", 1);
	SetVal(map1, "id", 101);
	SetVal(map1, "value", 1.123);
	SetVal(map1, "proxy2.id", 202);
	SetVal(map1, "proxy2.value", 1.1);
	SetVal(map1, "proxy2.deleted", "true");

	cout << "Create group proxy1" << endl;
	GroupProxy proxy1(&map1, "proxy1");
	SetVal(proxy1, "name", "proxy1");
	SetVal(proxy1, "id", 201);
	SetVal(proxy1, "value", 2.123);

	cout << "Create group proxy2" << endl;
	GroupProxy proxy2(&map1, "proxy2");
	SetVal(proxy2, "name", "proxy2");
	SetVal(proxy2, "value", 1.2);
	cout << "Create map2 & writeproxy2" << endl;
	SettingsMap map2;
	WriteProxy writeproxy2(&proxy2, &map2);
	SetVal(writeproxy2, "name", "writeproxy3");
	GetVal<int>(writeproxy2, "id");
	SetVal(writeproxy2, "value", 3.123);
	SetVal(writeproxy2, "deleted", "false");
	UnsetVal(writeproxy2, "deleted");
	UnsetVal(writeproxy2, "deleted");

	cout << "Get via map1" << endl;
	GetVal<string>(map1, "name");
	GetVal<int>(map1, "id");
	GetVal<double>(map1, "value");
	GetVal<string>(map1, "proxy1.name");
	GetVal<int>(map1, "proxy1.id");
	GetVal<double>(map1, "proxy1.value");
	GetVal<string>(map1, "proxy2.name");
	GetVal<int>(map1, "proxy2.id");
	GetVal<double>(map1, "proxy2.value");
	GetVal<string>(map1, "proxy2.deleted");

	cout << "Get via map2" << endl;
	GetVal<string>(map2, "name");
	GetVal<int>(map2, "id");
	GetVal<double>(map2, "value");
	GetVal<string>(map2, "deleted");

	/*SettingsFile settings(cfgFile);
	settings.Insert("debug.config.rewrited", "no");

	std::cout << "Laod settings from " << cfgFile << std::endl;
	settings.Load(cfgFile);
	std::cout << "Config version: " << settings.Get("version", "NO") << std::endl;
	std::cout << "DEBUG replaced value: " << settings.Get("debug.config.rewrited", "") << std::endl;

	ESD::Settings::SettingsGroupProxy debugConfig(settings, "debug");
	std::cout << "DEBUG replaced value by group proxy: " << debugConfig.Get("config.rewrited", "") << std::endl;*/

	return 0;
}
