/*
 * ssp.c
 *
 *  Created on: Jan 23, 2011
 *      Author: James
 */

#include "LPC13xx.h"                                   // LPC13xx definitions
#include "type.h"
#include "ssp.h"

#define SSEL_HIGH (LPC_GPIO0->MASKED_ACCESS[(1 << 2)] = (1 << 2))
#define SSEL_LOW  (LPC_GPIO0->MASKED_ACCESS[(1 << 2)] = 0)

inline void ssp_enable_cs(void) {
	SSEL_LOW;
}

inline void ssp_disable_cs(void) {
	SSEL_HIGH;
}

uint8_t ssp_transfer(uint8_t data) {
	LPC_SSP->DR = data;
	while((LPC_SSP->SR & (1<<2)) == 0);  // Ждем пока установится Rx Not Empty - завершение приема
	return LPC_SSP->DR;
}

void ssp_init(ssp_speed_t clk_speed) {
	uint8_t i, Dummy;

	LPC_SYSCON->PRESETCTRL |= (0x1 << 0);
	LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 11);

	LPC_IOCON->PIO0_8 &= ~0x07;	// SPI MISO
	LPC_IOCON->PIO0_8 |= 0x01;	//
	LPC_IOCON->PIO0_9 &= ~0x07; // SPI MOSI
	LPC_IOCON->PIO0_9 |= 0x01;	//

	LPC_IOCON->SCKLOC = 0x01;	// указываем какой из возможных выводов будем задействовать
	LPC_IOCON->PIO2_11 = 0x01;	// сам вывод P2.11 настраиваем на функцию 1 - SSP clock

	LPC_IOCON->PIO0_2 &= ~0x07;	// SPI SSEL используем простой GPIO вывод
	LPC_GPIO0->DIR |= (1 << 2);	// P0.2 настраиваем на вывод
	SSEL_HIGH;	// устанавливаем SSEL в единицу - отключаем карточку

	if (clk_speed == SSP_SLOW) {
		/* (PCLK / (CPSDVSR - [SCR+1])) = (7,200,000 / (2 x [8 + 1])) = 400 KHz */
		LPC_SYSCON->SSPCLKDIV = 10; // Делитель 10 для SPI
		// Формат SPI пакета 8 бит данных, CPOL = 0, CPHA = 0, SCR (доподнительный делитель) = 8
		LPC_SSP->CR0 = 0x0807;
	} else {
		/* (PCLK / (CPSDVSR - [SCR+1])) = (72,000,000 / (2 * [1 + 1])) = 18.0 MHz */
		LPC_SYSCON->SSPCLKDIV = 1;	// Делитель 1 для SPI
		// Формат SPI пакета 8 бит данных, CPOL = 0, CPHA = 0, SCR = 1
		LPC_SSP->CR0 = 0x0107;
	}
	// Минимальный предделитель частоты 0x02
	LPC_SSP->CPSR = 0x2;

	for (i = 0; i < 8; i++) {
		Dummy = LPC_SSP->DR; // очищаем буффер приёма RxFIFO
	}

	// Устанавливаем мастера и разрешаем работу SPI
	LPC_SSP->CR1 = 0x02;
}
