/*----------------------------------------------------------------------------
 *      U S B  -  K e r n e l
 *----------------------------------------------------------------------------
 *      Name:    mscuser.c
 *      Purpose: Mass Storage Class Custom User Module
 *      Version: V1.20
 *----------------------------------------------------------------------------
 *      This software is supplied "AS IS" without any warranties, express,
 *      implied or statutory, including but not limited to the implied
 *      warranties of fitness for purpose, satisfactory quality and
 *      noninfringement. Keil extends you a royalty-free right to reproduce
 *      and distribute executable files created using this software for use
 *      on NXP Semiconductors LPC microcontroller devices only. Nothing else 
 *      gives you the right to use this software.
 *
 *      Copyright (c) 2009 Keil - An ARM Company. All rights reserved.
 *---------------------------------------------------------------------------*/
#include "lpc13xx.h"
#include "type.h"
#include "usb.h"
#include "msccallback.h"
#include "sdcard.h"

const uint8_t InquiryStr[] = {'K','e','i','l',' ',' ',' ',' ',     \
                           'L','P','C','1','3','x','x',' ',     \
                           'D','i','s','k',' ',' ',' ',' ',     \
                           '1','.','0',' ',};

uint8_t CardBuffer[512];
uint32_t Sector = 0;
uint8_t Cached = 0;
uint8_t Changed = 0;

void SetLed(uint32_t val);

void SwitchSector(uint32_t number) {
	if(Cached) {
		if(Sector == number) {
			return;
		}
		if(Changed) {
			SD_WriteSector(Sector, CardBuffer);
			Changed = 0;
		}
	}
	Sector = number;
	if(SD_ReadSector(Sector, CardBuffer))
		while(1);
	Cached = 1;
}

void MSC_MemoryRead (uint32_t offset, uint8_t dst[], uint32_t length) {
  uint32_t n;
  SetLed(1);
  SwitchSector(offset/512);
  offset %= 512;
  for (n = 0; n < length; n++) {
    	dst[n] = CardBuffer[offset + n];
  }
  SetLed(0);
}

void MSC_MemoryWrite (uint32_t offset, uint8_t src[], uint32_t length) {
  uint32_t n;
  SetLed(1);
  SwitchSector(offset/512);
  offset %= 512;
  for (n = 0; n < length; n++) {
   	CardBuffer[offset+n] = src[n];
  }
  Changed = 1;
  if(offset + length == 512) {
	  SD_WriteSector(Sector, CardBuffer);
	  Changed = 0;
  }
  SetLed(0);
}
