/*
===============================================================================
 Name        : main.c
 Author      : 
 Version     :
 Copyright   : Copyright (C)
 Description : main definition
===============================================================================
*/

#ifdef __USE_CMSIS
#include "LPC13xx.h"
#endif

#include "gpio.h"
#include "uart.h"

// LPCXpresso processor card LED
#define LED_PORT 0		// Port for led
#define LED_BIT	 7		// Bit on port for led
#define LED_ON	 1		// Level to set port to turn on led
#define LED_OFF	 0		// Level to set port to turn off led

#define BUTTON_PORT	2		/* Порт для подключия кнопки */
#define BUTTON_BIT	10		/* Номер бита в порту для кнопки */
#define BUTTON_UP	1		/* Кнопка отжата */
#define BUTTON_DOWN	0		/* Кнопка нажата */

// --- Средства работы со временем - Системный таймер ---
static volatile uint32_t msTicks = 0;		// counts 1ms timeTicks

void SysTick_Handler(void)
{
	msTicks++;		// инкремент счётчика времени
}

void delay_ms(uint32_t ms)
{
	uint32_t startTicks;
	startTicks = msTicks;
	while((msTicks - startTicks) < ms);	// Ждем завершения периода
}

// --- Основная программа ---

int main(void) {
	char c;
	GPIOInit();
	GPIOSetDir(LED_PORT, LED_BIT, 1);
	GPIOSetValue(LED_PORT, LED_BIT, LED_OFF);
	GPIOSetDir(BUTTON_PORT, BUTTON_BIT, 0);
	SysTick_Config(SystemCoreClock / 1000);	// настройка таймера на период 1мс
	UARTInit(9600);			// Настройка UART на скорость 9600
	UARTPutChar('>');
	while(1) {
		c = UARTGetChar();
		switch(c) {
		case '?':	// Запросили состояние кнопки
			if(GPIOGetValue(BUTTON_PORT, BUTTON_BIT) == BUTTON_DOWN) {
				UARTSend((void*)"down\n", 5);
			} else {
				UARTSend((void*)"up\n", 3);
			}
			break;
		case '+':	// Запросили включение светодиода
			GPIOSetValue(LED_PORT, LED_BIT, LED_ON);
			break;
		case '-':	// Запросили выключение светодиода
			GPIOSetValue(LED_PORT, LED_BIT, LED_OFF);
			break;
		default:	// Нестандартный запрос
			if(c >= '0' && c < '9') {	// Запросили следующую цифру
				UARTPutChar(c + 1);		// Генерируем и отправляем следующую цифру
			}
		}
	}
	return 0 ;
}
