#include "LPC13xx.h"			/* LPC13xx Peripheral Registers */
#include "adc.h"

/*****************************************************************************
** Function name:		ADCInit
**
** Descriptions:		initialize ADC channel
**
** parameters:			ADC clock rate
** Returned value:		None
**
*****************************************************************************/
void ADCInit( uint32_t ADC_Clk )
{
  // Включаем питание на АЦП (отключаем режим Power down)
  LPC_SYSCON->PDRUNCFG &= ~(0x1<<4);

  // Включаем тактирование на АЦП
  LPC_SYSCON->SYSAHBCLKCTRL |= (1<<13);

  LPC_IOCON->JTAG_TDI_PIO0_11   = 0x02;	// Выбор функции AD0 для пина
  LPC_IOCON->JTAG_TMS_PIO1_0    = 0x02;	// Выбор функции AD1 для пина
  LPC_IOCON->JTAG_TDO_PIO1_1    = 0x02;	// Выбор функции AD2 для пина
  LPC_IOCON->JTAG_nTRST_PIO1_2    = 0x02;	// Выбор функции AD3 для пина
//  LPC_IOCON->ARM_SWDIO_PIO1_3    = 0x02;	// Выбор функции AD4 для пина (используется отладчиком)
  LPC_IOCON->PIO1_4    = 0x01;	// Выбор функции AD5 для пина
  LPC_IOCON->PIO1_10   = 0x01;	// Выбор функции AD6 для пина
  LPC_IOCON->PIO1_11   = 0x01;	// Выбор функции AD7 для пина

  LPC_ADC->CR = ((SystemCoreClock/LPC_SYSCON->SYSAHBCLKDIV)/ADC_Clk-1)<<8;
  return;
}

/*****************************************************************************
** Function name:		ADCRead
**
** Descriptions:		Read ADC channel
**
** parameters:			Channel number
** Returned value:		Value read, if interrupt driven, return channel #
**
*****************************************************************************/
uint32_t ADCRead( uint8_t channelNum )
{
  uint32_t regVal, ADC_Data;

  if( channelNum >= ADC_NUM ) {	// номер канала должен быть от 0 до 7. если он больше
	return 0;					// то сразу возвращаем 0
  }
  LPC_ADC->CR &= 0xFFFFFF00;	// сбрасываем выбор канала
  LPC_ADC->CR |= (1 << 24) | (1 << channelNum); // Переключаем канал, запуск преобразования
  while( 1 ) {					// ожидаем завершения преобразования
	regVal = ((volatile unsigned long *)&LPC_ADC->DR0)[channelNum];
	if ( regVal & ADC_DONE ) {	// читаем результат преобразования и проверяем на завершенность
	  break;
	}
  }
  LPC_ADC->CR &= 0xF8FFFFFF;	// останавливаем АЦП
  ADC_Data = ( regVal >> 6 ) & 0x3FF;	// извлекаем результат из считанного значения
  return ADC_Data;				// Возвращаем результат преобразования
}
