/*
===============================================================================
 Name        : main.c
 Author      : 
 Version     :
 Copyright   : Copyright (C)
 Description : main definition
===============================================================================
*/

#ifdef __USE_CMSIS
#include "LPC13xx.h"
#endif

#include "gpio.h"

// LPCXpresso processor card LED
#define LED_PORT 0		// Port for led
#define LED_BIT 7		// Bit on port for led
#define LED_ON 1		// Level to set port to turn on led
#define LED_OFF 0		// Level to set port to turn off led

// --- Средства работы со временем - Системный таймер ---
static volatile uint32_t msTicks = 0;		// counts 1ms timeTicks

void SysTick_Handler(void)
{
	msTicks++;		// инкремент счётчика времени
}

void delay_ms(uint32_t ms)
{
	uint32_t startTicks;
	startTicks = msTicks;
	if(startTicks > 0xFFFFFFFF - ms) {	// для случая "вблизи" верхней границы времени
		while(msTicks >= startTicks);
	}
	while((msTicks - startTicks) < ms);	// Ждем завершения периода
}

__INLINE uint32_t getUptime(void)
{
	return msTicks;
}

// --- Основная программа ---

int main(void) {
	GPIOInit();
	GPIOSetDir(LED_PORT, LED_BIT, 1);

	if (SysTick_Config(SystemCoreClock / 1000)) {	// настройка таймера на период 1мс
		GPIOSetValue(LED_PORT, LED_BIT, LED_ON);
		while(1);
	}
	NVIC_SetPriority(SysTick_IRQn, 1);		// задаем почти максимальный приоритет
	if ( !(SysTick->CTRL & SysTick_CTRL_CLKSOURCE_Msk) ) {
		LPC_SYSCON->SYSTICKCLKDIV = 0x08;		// из 16.6.1 замечание к внешнему таймеру (по примеру)
	}

	while(1) {
		GPIOSetValue(LED_PORT, LED_BIT, LED_ON);
		delay_ms(500);
		GPIOSetValue(LED_PORT, LED_BIT, LED_OFF);
		delay_ms(500);
	}
	return 0 ;
}
