/*
===============================================================================
 Name        : main.c
 Author      : 
 Version     :
 Copyright   : Copyright (C)
 Description : main definition
===============================================================================
*/

#ifdef __USE_CMSIS
#include "LPC13xx.h"
#endif

#define PWM_RERIOD	2000	/* Период ШИМ в микросекундах */

// --- Средства работы со временем - Системный таймер ---
static volatile uint32_t msTicks = 0;		// counts 1ms timeTicks

void SysTick_Handler(void)
{
	msTicks++;		// инкремент счётчика времени
}

void delay_ms(uint32_t ms)
{
	uint32_t startTicks;
	startTicks = msTicks;
	while((msTicks - startTicks) < ms);	// Ждем завершения периода
}

// --- Работа с ШИМ ---
void PWM16_init(uint16_t period)
{
	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<8);	// Разрешаем тактирование для таймера Timer1_16
    LPC_TMR16B1->PR  = SystemCoreClock / 1000000;	// Предделитель для получения частоты 1МГц

//	LPC_TMR16B1->EMR	= (1<<3) | (1<<10)	// MR3 используется для служебных целей (можно это и не писать) (не выведен на 1343)
//						| (3<<8) | (1<<2)	// установка вывода PWM2 (не выведен на 1343)
//						| (3<<6) | (1<<1)	// установка вывода PWM1
//						| (3<<4) | (1<<0)	// установка вывода PWM0
//						;

	LPC_IOCON->PIO1_9	&= ~0x07;
	LPC_IOCON->PIO1_9	|= 0x01;	// Вывод на Timer1_16 MAT0
	LPC_IOCON->PIO1_10	&= ~0x07;
	LPC_IOCON->PIO1_10	|= 0x02;	// Вывод на Timer1_16 MAT1

	LPC_TMR16B1->PWMC   = (1<<3)	// Разрешаем Match3 - по нему будет сброс
						| (1<<0)	// Разрешаем PWM0
						| (1<<1)	// Разрешаем PWM1
//						| (1<<2)	// Разрешаем PWM2 (не выведен на 1343)
						;

	LPC_TMR16B1->MR3 = period - 1;	// В регистр сравнения MR3 период ШИМ
	LPC_TMR16B1->MR0 = period/2;	// Величина ШИМ0
	LPC_TMR16B1->MR1 = period/2;	// Величина ШИМ1
//	LPC_TMR16B1->MR2 = period/2;	// Величина ШИМ2 (не используется в 1343)

	LPC_TMR16B1->MCR = (2<<9);		// Режим Сброс счётчика TC при его совпадении с MR3

	LPC_TMR16B1->TCR = (1<<0);		// Разрешить счет Timer1_16
}

void PWM16_set(uint8_t num, uint16_t value)
{
	if(num) {
		LPC_TMR16B1->MR1 = value;
	} else {
		LPC_TMR16B1->MR0 = value;
	}
}

// --- Основная программа ---

int main(void) {
	uint16_t pwm = 0;
	SysTick_Config(SystemCoreClock / 1000);	// настройка таймера на период 1мс
	PWM16_init(PWM_RERIOD);
	while(1) {
		PWM16_set(0, pwm);
		PWM16_set(1, PWM_RERIOD - pwm);
		delay_ms(100);
		pwm = (pwm < PWM_RERIOD) ? pwm + PWM_RERIOD/20 : 0;
	}
	return 0 ;
}
