/* lcd.c */

#ifdef __USE_CMSIS
#include "LPC13xx.h"
#endif

#include "gpio.h"
#include "ssp.h"
#include "lcd.h"

const uint8_t lcd_font[] =
{
     0x00, 0x00, 0x00, 0x00, 0x00,   // sp
     0x00, 0x00, 0x2f, 0x00, 0x00,    // !
     0x00, 0x07, 0x00, 0x07, 0x00,   // "
     0x14, 0x7f, 0x14, 0x7f, 0x14,   // #
     0x24, 0x2a, 0x7f, 0x2a, 0x12,   // $
     0xc4, 0xc8, 0x10, 0x26, 0x46,   // %
     0x36, 0x49, 0x55, 0x22, 0x50,   // &
     0x00, 0x05, 0x03, 0x00, 0x00,   // '
     0x00, 0x1c, 0x22, 0x41, 0x00,   // (
     0x00, 0x41, 0x22, 0x1c, 0x00,   // )
     0x14, 0x08, 0x3E, 0x08, 0x14,   // *
     0x08, 0x08, 0x3E, 0x08, 0x08,   // +
     0x00, 0x00, 0x50, 0x30, 0x00,   // ,
     0x10, 0x10, 0x10, 0x10, 0x10,   // -
     0x00, 0x60, 0x60, 0x00, 0x00,   // .
     0x20, 0x10, 0x08, 0x04, 0x02,   // /
     0x3E, 0x51, 0x49, 0x45, 0x3E,   // 0
     0x00, 0x42, 0x7F, 0x40, 0x00,   // 1
     0x42, 0x61, 0x51, 0x49, 0x46,   // 2
     0x21, 0x41, 0x45, 0x4B, 0x31,   // 3
     0x18, 0x14, 0x12, 0x7F, 0x10,   // 4
     0x27, 0x45, 0x45, 0x45, 0x39,   // 5
     0x3C, 0x4A, 0x49, 0x49, 0x30,   // 6
     0x01, 0x71, 0x09, 0x05, 0x03,   // 7
     0x36, 0x49, 0x49, 0x49, 0x36,   // 8
     0x06, 0x49, 0x49, 0x29, 0x1E,   // 9
     0x00, 0x36, 0x36, 0x00, 0x00,   // :
     0x00, 0x56, 0x36, 0x00, 0x00,   // ;
     0x08, 0x14, 0x22, 0x41, 0x00,   // <
     0x14, 0x14, 0x14, 0x14, 0x14,   // =
     0x00, 0x41, 0x22, 0x14, 0x08,   // >
     0x02, 0x01, 0x51, 0x09, 0x06,   // ?
     0x32, 0x49, 0x59, 0x51, 0x3E,   // @
     0x7E, 0x11, 0x11, 0x11, 0x7E,   // A
     0x7F, 0x49, 0x49, 0x49, 0x36,   // B
     0x3E, 0x41, 0x41, 0x41, 0x22,   // C
     0x7F, 0x41, 0x41, 0x22, 0x1C,   // D
     0x7F, 0x49, 0x49, 0x49, 0x41,   // E
     0x7F, 0x09, 0x09, 0x09, 0x01,   // F
     0x3E, 0x41, 0x49, 0x49, 0x7A,   // G
     0x7F, 0x08, 0x08, 0x08, 0x7F,   // H
     0x00, 0x41, 0x7F, 0x41, 0x00,   // I
     0x20, 0x40, 0x41, 0x3F, 0x01,   // J
     0x7F, 0x08, 0x14, 0x22, 0x41,   // K
     0x7F, 0x40, 0x40, 0x40, 0x40,   // L
     0x7F, 0x02, 0x0C, 0x02, 0x7F,   // M
     0x7F, 0x04, 0x08, 0x10, 0x7F,   // N
     0x3E, 0x41, 0x41, 0x41, 0x3E,   // O
     0x7F, 0x09, 0x09, 0x09, 0x06,   // P
     0x3E, 0x41, 0x51, 0x21, 0x5E,   // Q
     0x7F, 0x09, 0x19, 0x29, 0x46,   // R
     0x46, 0x49, 0x49, 0x49, 0x31,   // S
     0x01, 0x01, 0x7F, 0x01, 0x01,   // T
     0x3F, 0x40, 0x40, 0x40, 0x3F,   // U
     0x1F, 0x20, 0x40, 0x20, 0x1F,   // V
     0x3F, 0x40, 0x38, 0x40, 0x3F,   // W
     0x63, 0x14, 0x08, 0x14, 0x63,   // X
     0x07, 0x08, 0x70, 0x08, 0x07,   // Y
     0x61, 0x51, 0x49, 0x45, 0x43,   // Z
     0x00, 0x7F, 0x41, 0x41, 0x00,   // [
     0x55, 0x2A, 0x55, 0x2A, 0x55,   // 55
     0x00, 0x41, 0x41, 0x7F, 0x00,   // ]
     0x04, 0x02, 0x01, 0x02, 0x04,   // ^
     0x40, 0x40, 0x40, 0x40, 0x40,   // _
     0x00, 0x01, 0x02, 0x04, 0x00,   // '
     0x20, 0x54, 0x54, 0x54, 0x78,   // a
     0x7F, 0x48, 0x44, 0x44, 0x38,    // b
     0x38, 0x44, 0x44, 0x44, 0x20,   // c
     0x38, 0x44, 0x44, 0x48, 0x7F,   // d
     0x38, 0x54, 0x54, 0x54, 0x18,   // e
     0x08, 0x7E, 0x09, 0x01, 0x02,   // f
     0x0C, 0x52, 0x52, 0x52, 0x3E,   // g
     0x7F, 0x08, 0x04, 0x04, 0x78,   // h
     0x00, 0x44, 0x7D, 0x40, 0x00,   // i
     0x20, 0x40, 0x44, 0x3D, 0x00,   // j
     0x7F, 0x10, 0x28, 0x44, 0x00,   // k
     0x00, 0x41, 0x7F, 0x40, 0x00,   // l
     0x7C, 0x04, 0x18, 0x04, 0x78,   // m
     0x7C, 0x08, 0x04, 0x04, 0x78,   // n
     0x38, 0x44, 0x44, 0x44, 0x38,   // o
     0x7C, 0x14, 0x14, 0x14, 0x08,   // p
     0x08, 0x14, 0x14, 0x18, 0x7C,   // q
     0x7C, 0x08, 0x04, 0x04, 0x08,   // r
     0x48, 0x54, 0x54, 0x54, 0x20,   // s
     0x04, 0x3F, 0x44, 0x40, 0x20,   // t
     0x3C, 0x40, 0x40, 0x20, 0x7C,   // u
     0x1C, 0x20, 0x40, 0x20, 0x1C,   // v
     0x3C, 0x40, 0x30, 0x40, 0x3C,   // w
     0x44, 0x28, 0x10, 0x28, 0x44,   // x
     0x0C, 0x50, 0x50, 0x50, 0x3C,   // y
     0x44, 0x64, 0x54, 0x4C, 0x44,   // z
	 0x00, 0x06, 0x09, 0x09, 0x06    // Вє
};

uint32_t lcd_pos_x;
uint32_t lcd_pos_y;

#define LCD_ORIGINAL

#define LCD_RESET_PORT	2
#define LCD_RESET_PIN	0
#define LCD_DC_PORT	2
#define LCD_DC_PIN	1
#define LCD_SELECT_PORT	0
#define LCD_SELECT_PIN	2

void delay_ms(uint32_t ms);

void LCD_init ( void )
{
	delay_ms(100);	// Отрабатываем задержку до прихода дисплея в чувства
	GPIOSetDir(LCD_SELECT_PORT, LCD_SELECT_PIN, 1);		// Вывод SSEL на GPIO выход
	GPIOSetValue(LCD_SELECT_PORT, LCD_SELECT_PIN, 0);	// Устанавливаем низкий уровень на SSEL
	GPIOSetDir(LCD_RESET_PORT, LCD_RESET_PIN, 1);		// Вывод RESET на GPIO выход
	GPIOSetValue(LCD_RESET_PORT, LCD_RESET_PIN, 0);		// Устанавливаем низкий уровень на RESET
	delay_ms(100);	// Ждем завершения сброва
	GPIOSetValue(LCD_RESET_PORT, LCD_RESET_PIN, 1);		// Отпускаем сброс
	GPIOSetValue(LCD_SELECT_PORT, LCD_SELECT_PIN, 1);	// Снимаем выбор с дисплея

	GPIOSetDir(LCD_DC_PORT, LCD_DC_PIN, 1);		// Вывод DC на GPIO выход
	//GPIOSetValue(LCD_DC_PORT, LCD_DC_PIN, 1);	// Устанавливаем в 1 (не обязательно)

	SSPInit();	// Инициализация SPI (после этого SSEL на аппаратном контроле)

	LCD_writeCommand( 0x21 );  // LCD Extended Commands.
	LCD_writeCommand( 0xE0 );  // Set LCD Vop (Contrast).
	LCD_writeCommand( 0x04 );  // Set Temp coefficent.
#ifdef LCD_ORIGINAL
	LCD_writeCommand( 0x45 );  // Смещаем экран на 5 пикселей вверх
#endif
	LCD_writeCommand( 0x13 );  // LCD bias mode 1:48.
	LCD_writeCommand( 0x20 );  // LCD Standard Commands, Horizontal addressing mode.
	LCD_writeCommand( 0x0c );  // LCD in normal mode.
	LCD_clear();
}

void LCD_clear ( void ) {
	int i,j;
	for(i = 0; i < DISPLAY_HEIGHT; i++) {
		LCD_gotoXY(0, i);	// В начало строки
		for(j = 0; j < DISPLAY_WIDTH * (SYM_WIDHT + 1); j++) {
			LCD_writeData( 0x00 );	// Стираем строку по столбцам
		}
	}
	LCD_gotoXY(0, 0);  		// В левый верхний угол
}

void LCD_gotoXY ( uint32_t x, uint32_t y ) {
	if(x >= DISPLAY_WIDTH)	x = 0;
	if(y >= DISPLAY_HEIGHT)	y = 0;
	lcd_pos_x = x;
	lcd_pos_y = y;
#ifdef LCD_ORIGINAL
	y++;	// Увеличиваем номер строки для неоригинальных дисплеев
#endif
	LCD_writeCommand (0x80 | (x * SYM_WIDHT));   //column
	LCD_writeCommand (0x40 | y);   //row
}

void LCD_writeData ( unsigned char data ) {
	GPIOSetValue(LCD_DC_PORT, LCD_DC_PIN, 1);	// Устанавливаем в 1 (данные)
	SSPTransfer(data);			// Передача данных на дисплей
}

void LCD_writeCommand ( unsigned char command ) {
	GPIOSetValue(LCD_DC_PORT, LCD_DC_PIN, 0);	// Устанавливаем в 0 (комманда)
	SSPTransfer(command);		// Передача команды на дисплей
}

void LCD_writeChar ( char c ) {
	int i;
	if(c < 32 || c > 128) c = 32;
	const uint8_t *ptr = &lcd_font[(c - 32) * SYM_WIDHT];
	for(i = 0; i < SYM_WIDHT; i++) {
		LCD_writeData(*ptr);	// вывели столбец изображения символа
		ptr++;					// перешли к следующему столбцу
	}
	LCD_writeData(0);			// Вывели пустое пространство между символами
	lcd_pos_x++;
	if(lcd_pos_x >= DISPLAY_WIDTH) {
		lcd_pos_x = 0;
		lcd_pos_y++;
		if(lcd_pos_y >= DISPLAY_HEIGHT) {
			lcd_pos_y = 0;
		}
		LCD_gotoXY(lcd_pos_x, lcd_pos_y);
	}
}

void LCD_writeString ( const char *string ) {
	if(!string) return;
	while(*string) {
		LCD_writeChar(*string);	// вывели символ
		string++;	// перешли к следующему символу в строке
	}
}

