/* ssp.h */

#ifndef SSP_H_
#define SSP_H_

// размер буфферов приёма/передачи
#define SSP_FIFOSIZE		8

// Флаги регистра статуса
#define SSPSR_TFE		(1 << 0)
#define SSPSR_TNF		(1 << 1)
#define SSPSR_RNE		(1 << 2)
#define SSPSR_RFF		(1 << 3)
#define SSPSR_BSY		(1 << 4)

// Флаги регистра SSP CR0 (пока не используются)
#define SSPCR0_DSS		(1 << 0)
#define SSPCR0_FRF		(1 << 4)
#define SSPCR0_SPO		(1 << 6)
#define SSPCR0_SPH		(1 << 7)
#define SSPCR0_SCR		(1 << 8)

// Флаги регистра SSP CR1 (пока не используются)
#define SSPCR1_LBM		(1 << 0)
#define SSPCR1_SSE		(1 << 1)
#define SSPCR1_MS		(1 << 2)
#define SSPCR1_SOD		(1 << 3)

extern void SSPInit( void );
extern uint8_t SSPTransfer( uint8_t snd );

#endif /* SSP_H_ */
