/*
===============================================================================
 Name        : main.c
 Author      : 
 Version     :
 Copyright   : Copyright (C)
 Description : main definition
===============================================================================
*/

#ifdef __USE_CMSIS
#include "LPC13xx.h"
#endif

#include <stdio.h>
#include "gpio.h"
#include "adc.h"
#include "lcd.h"

// LPCXpresso processor card LED
#define LED_PORT 0		// Port for led
#define LED_BIT	 7		// Bit on port for led
#define LED_ON	 1		// Level to set port to turn on led
#define LED_OFF	 0		// Level to set port to turn off led

#define BUTTON_PORT	2		/* Порт для подключия кнопки */
#define BUTTON_BIT	10		/* Номер бита в порту для кнопки */
#define BUTTON_UP	1		/* Кнопка отжата */
#define BUTTON_DOWN	0		/* Кнопка нажата */

#define ADC_CLK		4500000	/* для частоты преобразования 4.5МГц */
#define ADC_VOLTAGE	3150	/* Напряжение опоры АЦП в миливольтах */

// --- Средства работы со временем - Системный таймер ---
static volatile uint32_t msTicks = 0;		// counts 1ms timeTicks

void SysTick_Handler(void)
{
	msTicks++;		// инкремент счётчика времени
}

void delay_ms(uint32_t ms)
{
	uint32_t startTicks;
	startTicks = msTicks;
	while((msTicks - startTicks) < ms);	// Ждем завершения периода
}

// --- Основная программа ---

int main(void) {
	uint32_t adcVal = 0, mV = 0, num;
	char buffer[32];
	GPIOInit();
	GPIOSetDir(LED_PORT, LED_BIT, 1);
	GPIOSetValue(LED_PORT, LED_BIT, LED_OFF);
	GPIOSetDir(BUTTON_PORT, BUTTON_BIT, 0);
	SysTick_Config(SystemCoreClock / 1000);	// настройка таймера на период 1мс
	ADCInit(ADC_CLK);
	LCD_init();
	// Вывод приветствия
	LCD_gotoXY(1, 0);
	LCD_writeString("Hello World!");
	LCD_gotoXY(2, 1);
	LCD_writeString("LPCXpresso");
	LCD_gotoXY(0, 2);
	LCD_writeString("Lesson ADC+SPI");
	LCD_gotoXY(0, 4);
	LCD_writeString("http://we.easyelectronics.ru");
	delay_ms(3000);
	while(1) {
		GPIOSetValue(LED_PORT, LED_BIT, LED_ON);
		for(num = 0; num < 6; num++) {
			adcVal = ADCRead(num);			// Измеряем значение очередного канала
			mV = adcVal * ADC_VOLTAGE / 1023;	// Преобразуем значение АЦП в миливольты
			sprintf(buffer, "%d: %4d %4dmV", num, adcVal, mV);
			LCD_gotoXY(0, num);
			LCD_writeString(buffer);			// Выводим результат
		}
		GPIOSetValue(LED_PORT, LED_BIT, LED_OFF);
		if(GPIOGetValue(BUTTON_PORT, BUTTON_BIT) != BUTTON_DOWN) {
			delay_ms(500);		// Если кнопка не нажата, добавляем задержку
		}
	}
	return 0 ;
}
