﻿/* ssp.c */

/*****************************************************************************
 *   ssp.c:  SSP C file for NXP LPC13xx Family Microprocessors
 *
 *   Copyright(C) 2008, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2008.07.20  ver 1.00    Preliminary version, first Release
 *
*****************************************************************************/
#include "LPC13xx.h"			/* LPC13xx Peripheral Registers */
#include "gpio.h"
#include "ssp.h"

void SSPInit( void )
{
	LPC_SYSCON->PRESETCTRL	|= (1<<0);	// Включаем модуль SSP
	LPC_SYSCON->SYSAHBCLKCTRL	|= (1<<11);	// и его тактирование
	LPC_SYSCON->SSPCLKDIV	 = 0x01;		// Предделитель тактовой частоты модуля в 1
	LPC_IOCON->PIO0_8	&= ~0x07;	// MISO функция для пина
	LPC_IOCON->PIO0_8	|= 0x01;
	LPC_IOCON->PIO0_9	&= ~0x07;	// MOSI функция для пина
	LPC_IOCON->PIO0_9	|= 0x01;
	LPC_IOCON->SCKLOC	 = 1;		// SCK на вывод 2.11
	LPC_IOCON->PIO2_11	 = 0x01;	// SCK функция для пина
	LPC_IOCON->PIO0_2	&= ~0x07;	// SSEL функция для пина
	LPC_IOCON->PIO0_2	|= 0x01;

	// F = SSP0CLKDIV = 2 -- (PCLK / (CPSDVSR X [SCR+1])) = (72,000,000 / (2 x [8 + 1])) = 4.0 MHz
	LPC_SSP->CR0	= ( (7<<0)		// Размер данных 0111 - 8 бит
					  | (0<<4)		// Формат фрейма 00 - SPI
					  | (0<<6)		// Полярность 0 - низкий уровень между фреймами
					  | (0<<7)		// Фаза 0 - по нарастанию
					  | (8<<8)		// Делитель частоты шины на бит
					  ) ;

	LPC_SSP->CPSR = 2;	// пердделитель (доступно 2-254, кратно 2)

	uint8_t i, Dummy;
	for ( i = 0; i < SSP_FIFOSIZE; i++ ) {
		Dummy = LPC_SSP->DR;		// Очистка буффера приёма
	}

	// Разрешение работы
	LPC_SSP->CR1	= ( (0<<0)	// 0 - Loop Back Mode Normal
					  | (1<<1)	// Разрешение работы 1 - разрешено
					  | (0<<2)	// Режим ведущий-ведомый 0 - мастер
					  );

	return;
}

uint8_t SSPTransfer( uint8_t snd )
{
	// Ждем освобождения места в буфера передачи
	while ( (LPC_SSP->SR & (SSPSR_TNF|SSPSR_BSY)) != SSPSR_TNF );
	// Помещаем данные на передачу (запускаем передачу)
	LPC_SSP->DR = snd;
	// Ждем появления данных в буфере приёма
	while ( (LPC_SSP->SR & (SSPSR_BSY|SSPSR_RNE)) != SSPSR_RNE );
	// Считываем принятые данные и возвращаем их
	return LPC_SSP->DR;
}
