/*
===============================================================================
 Name        : main.c
 Author      : 
 Version     :
 Copyright   : Copyright (C)
 Description : main definition
===============================================================================
*/

#ifdef __USE_CMSIS
#include "LPC13xx.h"
#endif

#include <stdio.h>
#include "gpio.h"
#include "adc.h"

// LPCXpresso processor card LED
#define LED_PORT 0		// Port for led
#define LED_BIT	 7		// Bit on port for led
#define LED_ON	 1		// Level to set port to turn on led
#define LED_OFF	 0		// Level to set port to turn off led

#define BUTTON_PORT	2		/* Порт для подключия кнопки */
#define BUTTON_BIT	10		/* Номер бита в порту для кнопки */
#define BUTTON_UP	1		/* Кнопка отжата */
#define BUTTON_DOWN	0		/* Кнопка нажата */

#define ADC_CLK		4500000	/* для частоты преобразования 4.5МГц */
#define ADC_CHAH	5		/* Используемый канал АЦП */
#define ADC_VOLTAGE	3150	/* Напряжение опоры АЦП в миливольтах */

// --- Средства работы со временем - Системный таймер ---
static volatile uint32_t msTicks = 0;		// counts 1ms timeTicks

void SysTick_Handler(void)
{
	msTicks++;		// инкремент счётчика времени
}

void delay_ms(uint32_t ms)
{
	uint32_t startTicks;
	startTicks = msTicks;
	if(startTicks > 0xFFFFFFFF - ms) {	// для случая "вблизи" верхней границы времени
		while(msTicks >= startTicks);
	}
	while((msTicks - startTicks) < ms);	// Ждем завершения периода
}

// --- Основная программа ---

int main(void) {
	uint32_t adcVal = 0, mV = 0;
	GPIOInit();
	GPIOSetDir(LED_PORT, LED_BIT, 1);
	GPIOSetValue(LED_PORT, LED_BIT, LED_OFF);
	GPIOSetDir(BUTTON_PORT, BUTTON_BIT, 0);
	SysTick_Config(SystemCoreClock / 1000);	// настройка таймера на период 1мс
	ADCInit(ADC_CLK);
	while(1) {
		adcVal = ADCRead(ADC_CHAH);
		if(GPIOGetValue(BUTTON_PORT, BUTTON_BIT) == BUTTON_DOWN) {
			mV = adcVal * ADC_VOLTAGE / 1023;	// Преобразуем значение АЦП в миливольты
			printf("ADC %d value = %4d , volage = %d mV\n", ADC_CHAH, adcVal, mV);
			delay_ms(100);
		} else {
			GPIOSetValue(LED_PORT, LED_BIT, LED_ON);
			delay_ms(adcVal);
			GPIOSetValue(LED_PORT, LED_BIT, LED_OFF);
			delay_ms(adcVal);
		}
	}
	return 0 ;
}
