//------------------------------------------------------------------------------
// Файл		: ubuntu10bold.c
// Создан	: 06.07.2011
// Автор	: Панзыга П.П.
// Описание	: Реализация шрифта Ubuntu 10pt Bold только латинница.
// Copyright (c) 2011
//------------------------------------------------------------------------------

#include <stdint.h>
#include "font.h"

// Font		: Ubuntu 10 bold
// Original	: 1456 bytes in 95 symbols
// Table	: 380 aligned 285 packed
// Width	: 13 max 0.4 avr
// Height	: 14 pixels
// Unused	: 3724 bits 465.4 bytes 32.0%
// Result	: 566 colomns 1027 bytes
// PackTable	: 190 bytes
// Unused	: 292 bits 36.4 bytes 3.6%

// Font data for Ubuntu 10pt Bold
const uint8_t ubuntu10ptBoldCharBitmaps[] = {
	0x00, 0x00, 0x00, 0x00, 
	0x0f, 0xff, 0x3c, 0x00, 
	0x06, 0xf7, 0xbd, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xd9, 0xbf, 0xff, 0xdb, 0x7f, 0xff, 0xb3, 0x60, 0x00, 0x00, 0x00, 
	0x30, 0xc7, 0xff, 0xc3, 0x87, 0x87, 0x0f, 0xff, 0x8c, 0x30, 0x00, 
	0x00, 0x00, 0x00, 0x70, 0xcd, 0x98, 0xdb, 0x0d, 0xb0, 0x76, 0xe0, 0xdb, 0x0d, 0xb1, 0x9b, 0x30, 0xe0, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x38, 0x7c, 0x6c, 0x38, 0x76, 0xde, 0xce, 0xfe, 0x7b, 0x00, 0x00, 0x00, 
	0x3f, 0xc0, 0x00, 0x00, 
	0x02, 0x76, 0xcc, 0xcc, 0xcc, 0x67, 0x20, 
	0x04, 0xe6, 0x33, 0x33, 0x33, 0x6e, 0x40, 
	0x00, 0x09, 0x5f, 0xa9, 0x40, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x30, 0xcf, 0xff, 0x30, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x0d, 0xbc, 0x00, 
	0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x3c, 0x00, 
	0x00, 0x31, 0xc6, 0x18, 0xe3, 0x0c, 0x71, 0x86, 0x38, 0xc0, 0x00, 
	0x00, 0x07, 0x9e, 0xcf, 0x3c, 0xf3, 0xcd, 0xe7, 0x80, 0x00, 0x00, 
	0x00, 0x3f, 0xb3, 0x33, 0x33, 0x30, 0x00, 
	0x00, 0x07, 0xbf, 0x0c, 0x31, 0x8c, 0x63, 0xff, 0xc0, 0x00, 0x00, 
	0x00, 0x07, 0xbf, 0x8d, 0xf7, 0x83, 0x0f, 0xff, 0x80, 0x00, 0x00, 
	0x00, 0x00, 0x30, 0xe3, 0xcd, 0xb3, 0x7f, 0xfe, 0x18, 0x30, 0x00, 0x00, 0x00, 
	0x00, 0x07, 0xdf, 0x63, 0xef, 0xc3, 0x0f, 0xff, 0x80, 0x00, 0x00, 
	0x00, 0x01, 0x9e, 0x63, 0xef, 0xf3, 0xcf, 0xf7, 0x80, 0x00, 0x00, 
	0x00, 0x0f, 0xff, 0x08, 0x63, 0x0c, 0x21, 0x86, 0x00, 0x00, 0x00, 
	0x00, 0x07, 0xbf, 0xcf, 0x37, 0xb7, 0xcf, 0xf7, 0x80, 0x00, 0x00, 
	0x00, 0x07, 0xbf, 0xcf, 0x3f, 0xdf, 0x1d, 0xe7, 0x00, 0x00, 0x00, 
	0x00, 0xf0, 0x3c, 0x00, 
	0x00, 0x06, 0xc0, 0x0d, 0xbc, 0x00, 
	0x00, 0x00, 0x00, 0x9f, 0xd8, 0xf1, 0xc2, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0xff, 0xc0, 0xff, 0xf0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x83, 0xc7, 0xc3, 0x7f, 0xc8, 0x00, 0x00, 0x00, 
	0x03, 0xef, 0xc3, 0x0c, 0x63, 0x0c, 0x00, 0xc3, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x7c, 0x1f, 0xe7, 0x0d, 0xde, 0xf7, 0xde, 0xdb, 0xdb, 0x7b, 0xff, 0xbf, 0x38, 0x03, 0xf8, 0x1f, 0x00, 
	0x00, 0x00, 0x07, 0x03, 0x83, 0x61, 0xb1, 0xdc, 0xfe, 0x7f, 0x71, 0xf0, 0x60, 0x00, 0x00, 0x00, 
	0x00, 0x03, 0xf7, 0xfc, 0x7f, 0xbf, 0xe3, 0xc7, 0xff, 0xf0, 0x00, 0x00, 0x00, 
	0x00, 0x03, 0xdf, 0xe3, 0x0c, 0x30, 0xe1, 0xf3, 0xc0, 0x00, 0x00, 
	0x00, 0x00, 0xfc, 0xfe, 0xc7, 0xc3, 0xc3, 0xc3, 0xc7, 0xfe, 0xfc, 0x00, 0x00, 0x00, 
	0x00, 0x0f, 0xff, 0xc3, 0xef, 0xb0, 0xc3, 0xff, 0xc0, 0x00, 0x00, 
	0x00, 0x0f, 0xff, 0xc3, 0x0f, 0xff, 0xc3, 0x0c, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xfb, 0xfe, 0x18, 0x31, 0xe3, 0xe6, 0xfc, 0xf8, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xff, 0xff, 0xc3, 0xc3, 0xc3, 0xc3, 0x00, 0x00, 0x00, 
	0x0f, 0xff, 0xfc, 0x00, 
	0x00, 0x00, 0xc3, 0x0c, 0x30, 0xc3, 0x0f, 0xff, 0x80, 0x00, 0x00, 
	0x00, 0x00, 0xc3, 0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0xc6, 0xc3, 0x00, 0x00, 0x00, 
	0x00, 0x0c, 0x30, 0xc3, 0x0c, 0x30, 0xc3, 0xff, 0xc0, 0x00, 0x00, 
	0x00, 0x00, 0x01, 0x83, 0x38, 0xe7, 0x1d, 0xb6, 0xf6, 0xde, 0x73, 0xce, 0x78, 0x8f, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xc3, 0xe3, 0xf3, 0xfb, 0xdb, 0xcf, 0xc7, 0xc7, 0xc3, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x3c, 0x7e, 0xe7, 0xc3, 0xc3, 0xc3, 0xe7, 0x7e, 0x3c, 0x00, 0x00, 0x00, 
	0x00, 0x0f, 0xbf, 0xcf, 0x3f, 0xfe, 0xc3, 0x0c, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x3c, 0x7e, 0xe7, 0xc3, 0xc3, 0xc3, 0xe7, 0x7e, 0x3c, 0x18, 0x0e, 0x00, 
	0x00, 0x00, 0xf8, 0xfe, 0xc6, 0xc6, 0xfe, 0xf8, 0xcc, 0xc6, 0xc7, 0x00, 0x00, 0x00, 
	0x00, 0x07, 0xff, 0xc3, 0x87, 0x87, 0x0f, 0xff, 0x80, 0x00, 0x00, 
	0x00, 0x00, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0x7e, 0x3c, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x30, 0x6c, 0x66, 0x33, 0x18, 0xd8, 0x6c, 0x36, 0x0e, 0x07, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x30, 0x07, 0x8e, 0x36, 0x73, 0x33, 0xd9, 0xb6, 0xcd, 0xb6, 0x39, 0xe1, 0xc7, 0x0e, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x38, 0xec, 0x63, 0x60, 0xe0, 0x70, 0x38, 0x36, 0x31, 0xb8, 0xe0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 
	0x00, 0x0f, 0xff, 0x18, 0x63, 0x18, 0x63, 0xff, 0xc0, 0x00, 0x00, 
	0x0f, 0xfc, 0xcc, 0xcc, 0xcc, 0xcf, 0xf0, 
	0x03, 0x0e, 0x18, 0x61, 0xc3, 0x0c, 0x38, 0x61, 0x87, 0x0c, 0x00, 
	0x0f, 0xf3, 0x33, 0x33, 0x33, 0x3f, 0xf0, 
	0x00, 0x08, 0xed, 0xee, 0x20, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xc0, 
	0x2d, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0f, 0x7c, 0x6f, 0xdf, 0xde, 0x00, 0x00, 
	0x03, 0x0c, 0x30, 0xfb, 0xfc, 0xf3, 0xcf, 0xff, 0x80, 0x00, 0x00, 
	0x00, 0x00, 0x07, 0xff, 0x18, 0xc7, 0xde, 0x00, 0x00, 
	0x00, 0x30, 0xc3, 0x7f, 0xfc, 0xf3, 0xcf, 0xf7, 0xc0, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x7b, 0xfc, 0xff, 0xc3, 0xf7, 0xc0, 0x00, 0x00, 
	0x07, 0xfc, 0xff, 0xcc, 0xcc, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x7f, 0xfc, 0xf3, 0xfd, 0xf0, 0xdf, 0xf8, 0x00, 
	0x03, 0x0c, 0x30, 0xfb, 0xfc, 0xf3, 0xcf, 0x3c, 0xc0, 0x00, 0x00, 
	0x3c, 0xff, 0xfc, 0x00, 
	0x03, 0x30, 0x33, 0x33, 0x33, 0x3f, 0xe0, 
	0x01, 0x83, 0x06, 0x0c, 0x79, 0xb6, 0x78, 0xd9, 0x9b, 0x18, 0x00, 0x00, 0x00, 
	0x1b, 0x6d, 0xb6, 0xdd, 0x80, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xbf, 0xfc, 0xcf, 0x33, 0xcc, 0xf3, 0x3c, 0xcc, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0xfb, 0xfc, 0xf3, 0xcf, 0x3c, 0xc0, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x7b, 0xfc, 0xf3, 0xcf, 0xf7, 0x80, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0xfb, 0xfc, 0xf3, 0xcf, 0xff, 0xb0, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x7f, 0xfc, 0xf3, 0xcf, 0xf7, 0xc3, 0x0c, 0x00, 
	0x00, 0x00, 0x0f, 0xff, 0x18, 0xc6, 0x30, 0x00, 0x00, 
	0x00, 0x00, 0x07, 0xff, 0x1f, 0x1f, 0xfc, 0x00, 0x00, 
	0x00, 0xcc, 0xff, 0xcc, 0xcf, 0x70, 0x00, 
	0x00, 0x00, 0x00, 0xcf, 0x3c, 0xf3, 0xcf, 0xf7, 0xc0, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x0c, 0x78, 0xdb, 0x36, 0x6c, 0x70, 0xe0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x47, 0x9c, 0xdb, 0xb3, 0x56, 0x2a, 0x87, 0x70, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x0c, 0x6d, 0x8e, 0x1c, 0x38, 0xdb, 0x18, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x0c, 0x78, 0xdb, 0x36, 0x7c, 0x70, 0xe7, 0x8e, 0x00, 0x00, 
	0x00, 0x00, 0x0f, 0xfc, 0xce, 0x67, 0xfe, 0x00, 0x00, 
	0x03, 0x76, 0x66, 0xee, 0x66, 0x67, 0x30, 
	0x3f, 0xff, 0xff, 0xc0, 
	0x0c, 0xe6, 0x66, 0x77, 0x66, 0x6e, 0xc0, 
	0x00, 0x00, 0x00, 0x01, 0x9f, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

const FONT_CHAR_INFO ubuntu10ptBoldCharDescriptors[] = {
	{2, 0},	// 0x20  32  
	{2, 4},	// 0x21  33 !
	{5, 8},	// 0x22  34 "
	{7, 17},	// 0x23  35 #
	{6, 30},	// 0x24  36 $
	{12, 41},	// 0x25  37 %
	{8, 62},	// 0x26  38 &
	{2, 76},	// 0x27  39 '
	{4, 80},	// 0x28  40 (
	{4, 87},	// 0x29  41 )
	{5, 94},	// 0x2a  42 *
	{6, 103},	// 0x2b  43 +
	{3, 114},	// 0x2c  44 ,
	{4, 120},	// 0x2d  45 -
	{2, 127},	// 0x2e  46 .
	{6, 131},	// 0x2f  47 /
	{6, 142},	// 0x30  48 0
	{4, 153},	// 0x31  49 1
	{6, 160},	// 0x32  50 2
	{6, 171},	// 0x33  51 3
	{7, 182},	// 0x34  52 4
	{6, 195},	// 0x35  53 5
	{6, 206},	// 0x36  54 6
	{6, 217},	// 0x37  55 7
	{6, 228},	// 0x38  56 8
	{6, 239},	// 0x39  57 9
	{2, 250},	// 0x3a  58 :
	{3, 254},	// 0x3b  59 ;
	{5, 260},	// 0x3c  60 <
	{6, 269},	// 0x3d  61 =
	{6, 280},	// 0x3e  62 >
	{6, 291},	// 0x3f  63 ?
	{11, 302},	// 0x40  64 @
	{9, 322},	// 0x41  65 A
	{7, 338},	// 0x42  66 B
	{6, 351},	// 0x43  67 C
	{8, 362},	// 0x44  68 D
	{6, 376},	// 0x45  69 E
	{6, 387},	// 0x46  70 F
	{7, 398},	// 0x47  71 G
	{8, 411},	// 0x48  72 H
	{2, 425},	// 0x49  73 I
	{6, 429},	// 0x4a  74 J
	{8, 440},	// 0x4b  75 K
	{6, 454},	// 0x4c  76 L
	{11, 465},	// 0x4d  77 M
	{8, 485},	// 0x4e  78 N
	{8, 499},	// 0x4f  79 O
	{6, 513},	// 0x50  80 P
	{8, 524},	// 0x51  81 Q
	{8, 538},	// 0x52  82 R
	{6, 552},	// 0x53  83 S
	{8, 563},	// 0x54  84 T
	{8, 577},	// 0x55  85 U
	{9, 591},	// 0x56  86 V
	{13, 607},	// 0x57  87 W
	{9, 630},	// 0x58  88 X
	{8, 646},	// 0x59  89 Y
	{6, 660},	// 0x5a  90 Z
	{4, 671},	// 0x5b  91 [
	{6, 678},	// 0x5c  92 backslash
	{4, 689},	// 0x5d  93 ]
	{5, 696},	// 0x5e  94 ^
	{7, 705},	// 0x5f  95 _
	{2, 718},	// 0x60  96 `
	{5, 722},	// 0x61  97 a
	{6, 731},	// 0x62  98 b
	{5, 742},	// 0x63  99 c
	{6, 751},	// 0x64 100 d
	{6, 762},	// 0x65 101 e
	{4, 773},	// 0x66 102 f
	{6, 780},	// 0x67 103 g
	{6, 791},	// 0x68 104 h
	{2, 802},	// 0x69 105 i
	{4, 806},	// 0x6a 106 j
	{7, 813},	// 0x6b 107 k
	{3, 826},	// 0x6c 108 l
	{10, 832},	// 0x6d 109 m
	{6, 850},	// 0x6e 110 n
	{6, 861},	// 0x6f 111 o
	{6, 872},	// 0x70 112 p
	{6, 883},	// 0x71 113 q
	{5, 894},	// 0x72 114 r
	{5, 903},	// 0x73 115 s
	{4, 912},	// 0x74 116 t
	{6, 919},	// 0x75 117 u
	{7, 930},	// 0x76 118 v
	{11, 943},	// 0x77 119 w
	{7, 963},	// 0x78 120 x
	{7, 976},	// 0x79 121 y
	{5, 989},	// 0x7a 122 z
	{4, 998},	// 0x7b 123 {
	{2, 1005},	// 0x7c 124 |
	{4, 1009},	// 0x7d 125 }
	{6, 1016},	// 0x7e 126 ~
};

// Font information for Ubuntu 10pt Bold
const FONT_INFO ubuntu10ptBoldFontInfo =
{
	14,	// Character height
	' ',	// The first character available
	126,	// The last character available
	FONT_PACKEDDATA,	// Character flags
	ubuntu10ptBoldCharDescriptors,	// Character decriptor array
	ubuntu10ptBoldCharBitmaps,	// Character bitmap array
};
