//------------------------------------------------------------------------------
// Файл		: ubuntu10.c
// Создан	: 06.07.2011
// Автор	: Панзыга П.П.
// Описание	: Реализация шрифта Ubuntu 10pt только латинница.
// Copyright (c) 2011
//------------------------------------------------------------------------------

#include <stdint.h>
#include "font.h"

// Font		: Ubuntu 10
// Original	: 1442 bytes in 95 symbols
// Table	: 380 aligned 285 packed
// Width	: 11 max 0.3 avr
// Height	: 14 pixels
// Unused	: 4550 bits 568.6 bytes 39.4%
// Result	: 499 colomns 915 bytes
// PackTable	: 190 bytes
// Unused	: 334 bits 41.6 bytes 4.6%

// Font data for Ubuntu 10pt
const uint8_t ubuntu10ptCharBitmaps[] = {
	0x00, 0x00, 0x00, 0x00, 
	0x3f, 0x60, 
	0x16, 0xd0, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x50, 0xaf, 0xe5, 0x0a, 0x14, 0xfe, 0xa1, 0x40, 0x00, 0x04, 0x00, 
	0x21, 0x1f, 0x08, 0x20, 0x82, 0x08, 0x7c, 0x42, 0x00, 
	0x00, 0x00, 0x18, 0x92, 0x89, 0x44, 0xc1, 0xac, 0x19, 0x14, 0x8a, 0x48, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xc2, 0x44, 0x89, 0x0c, 0x29, 0x8b, 0x09, 0xe8, 0x00, 0x00, 0x00, 
	0x70, 0x00, 
	0x05, 0x29, 0x24, 0x91, 0x22, 0x00, 
	0x11, 0x22, 0x49, 0x25, 0x28, 0x00, 
	0x00, 0x09, 0x57, 0x2a, 0x20, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x10, 0x9f, 0x21, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x15, 0x80, 
	0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
	0x00, 0x60, 
	0x00, 0x42, 0x21, 0x08, 0x84, 0x42, 0x11, 0x08, 0x00, 
	0x00, 0x1d, 0x18, 0xc6, 0x31, 0x8c, 0x5c, 0x00, 0x00, 
	0x00, 0xba, 0x49, 0x24, 0x80, 0x00, 
	0x00, 0x1d, 0x10, 0x84, 0x44, 0x44, 0x3e, 0x00, 0x00, 
	0x00, 0x3c, 0x10, 0x85, 0xc1, 0x08, 0x7c, 0x00, 0x00, 
	0x00, 0x04, 0x65, 0x29, 0x52, 0xf8, 0x84, 0x00, 0x00, 
	0x00, 0x1e, 0x84, 0x21, 0xc1, 0x08, 0x7c, 0x00, 0x00, 
	0x00, 0x0c, 0x88, 0x7a, 0x31, 0x8c, 0x5c, 0x00, 0x00, 
	0x00, 0x3e, 0x11, 0x10, 0x84, 0x42, 0x10, 0x00, 0x00, 
	0x00, 0x1d, 0x18, 0xc5, 0xd1, 0x8c, 0x5c, 0x00, 0x00, 
	0x00, 0x1d, 0x18, 0xc6, 0x2f, 0x08, 0xb8, 0x00, 0x00, 
	0x0c, 0x60, 
	0x00, 0x50, 0x15, 0x80, 
	0x00, 0x00, 0x00, 0x0d, 0x90, 0x60, 0xc0, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0xfc, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x60, 0xc1, 0x36, 0x00, 0x00, 0x00, 
	0x00, 0xe1, 0x12, 0x44, 0x04, 0x40, 0x00, 
	0x00, 0x07, 0x82, 0x11, 0x02, 0x8e, 0x64, 0x99, 0x26, 0x49, 0x92, 0x63, 0x64, 0x00, 0x80, 0x1e, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x02, 0x81, 0x41, 0x10, 0x88, 0x44, 0x7f, 0x20, 0xa0, 0x20, 0x00, 0x00, 0x00, 
	0x00, 0x0f, 0xa1, 0x86, 0x1f, 0xa1, 0x86, 0x1f, 0x80, 0x00, 0x00, 
	0x00, 0x00, 0xf2, 0x18, 0x10, 0x20, 0x40, 0x80, 0x84, 0xf0, 0x00, 0x00, 0x00, 
	0x00, 0x03, 0xe4, 0x28, 0x30, 0x60, 0xc1, 0x83, 0x0b, 0xe0, 0x00, 0x00, 0x00, 
	0x00, 0x3f, 0x08, 0x43, 0xd0, 0x84, 0x3e, 0x00, 0x00, 
	0x00, 0x0f, 0xe0, 0x82, 0x0f, 0xa0, 0x82, 0x08, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xf2, 0x18, 0x10, 0x20, 0x41, 0x82, 0x84, 0xf8, 0x00, 0x00, 0x00, 
	0x00, 0x02, 0x0c, 0x18, 0x30, 0x7f, 0xc1, 0x83, 0x06, 0x08, 0x00, 0x00, 0x00, 
	0x3f, 0xe0, 
	0x00, 0x00, 0x41, 0x04, 0x10, 0x41, 0x06, 0x17, 0x80, 0x00, 0x00, 
	0x00, 0x02, 0x14, 0x49, 0x14, 0x30, 0x58, 0x89, 0x0a, 0x08, 0x00, 0x00, 0x00, 
	0x00, 0x08, 0x20, 0x82, 0x08, 0x20, 0x82, 0x0f, 0xc0, 0x00, 0x00, 
	0x00, 0x00, 0x20, 0x38, 0x3c, 0x1d, 0x16, 0x8b, 0x29, 0x94, 0xc4, 0x60, 0x20, 0x00, 0x00, 0x00, 
	0x00, 0x02, 0x0e, 0x1a, 0x36, 0x64, 0xc5, 0x8b, 0x0e, 0x08, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x3c, 0x42, 0x81, 0x81, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 
	0x00, 0x03, 0xe4, 0x28, 0x30, 0x61, 0x7c, 0x81, 0x02, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x3c, 0x42, 0x81, 0x81, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x08, 0x06, 0x00, 
	0x00, 0x03, 0xe4, 0x28, 0x50, 0xa1, 0x7c, 0x89, 0x0a, 0x08, 0x00, 0x00, 0x00, 
	0x00, 0x1f, 0x08, 0x41, 0xc1, 0x08, 0x7c, 0x00, 0x00, 
	0x00, 0x03, 0xf8, 0x81, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00, 
	0x00, 0x02, 0x0c, 0x18, 0x30, 0x60, 0xc1, 0x82, 0x88, 0xe0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x20, 0x28, 0x24, 0x12, 0x08, 0x88, 0x44, 0x14, 0x0a, 0x02, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0xc2, 0x18, 0x42, 0x94, 0x92, 0x92, 0x52, 0x51, 0x4a, 0x28, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x02, 0x0a, 0x22, 0x85, 0x04, 0x14, 0x28, 0x8a, 0x08, 0x00, 0x00, 0x00, 
	0x00, 0x02, 0x0a, 0x24, 0x45, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00, 
	0x00, 0x3e, 0x11, 0x10, 0x88, 0x44, 0x3e, 0x00, 0x00, 
	0x1e, 0x49, 0x24, 0x92, 0x4e, 0x00, 
	0x04, 0x20, 0x84, 0x20, 0x84, 0x20, 0x84, 0x10, 0x80, 
	0x1c, 0x92, 0x49, 0x24, 0x9e, 0x00, 
	0x00, 0x00, 0x41, 0x44, 0x48, 0xa0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 
	0x24, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x07, 0x04, 0x2f, 0x8c, 0x5e, 0x00, 0x00, 
	0x02, 0x08, 0x20, 0xfa, 0x18, 0x61, 0x86, 0x1f, 0x80, 0x00, 0x00, 
	0x00, 0x00, 0x07, 0xc2, 0x10, 0x84, 0x1e, 0x00, 0x00, 
	0x00, 0x10, 0x41, 0x7e, 0x18, 0x61, 0x86, 0x17, 0xc0, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x7a, 0x18, 0x7f, 0x82, 0x07, 0xc0, 0x00, 0x00, 
	0x07, 0x88, 0xf8, 0x88, 0x88, 0x80, 0x00, 
	0x00, 0x00, 0x00, 0x7e, 0x18, 0x61, 0x86, 0x17, 0xc1, 0xf8, 0x00, 
	0x02, 0x08, 0x20, 0xfa, 0x18, 0x61, 0x86, 0x18, 0x40, 0x00, 0x00, 
	0x6f, 0xe0, 
	0x04, 0x82, 0x49, 0x24, 0x9c, 0x00, 
	0x04, 0x21, 0x08, 0xca, 0x98, 0xa4, 0xa2, 0x00, 0x00, 
	0x12, 0x49, 0x24, 0x91, 0x80, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x74, 0x46, 0x23, 0x11, 0x88, 0xc4, 0x62, 0x20, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0f, 0x46, 0x31, 0x8c, 0x62, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x7a, 0x18, 0x61, 0x86, 0x17, 0x80, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0xfa, 0x18, 0x61, 0x86, 0x1f, 0xa0, 0x80, 0x00, 
	0x00, 0x00, 0x00, 0x7e, 0x18, 0x61, 0x86, 0x17, 0xc1, 0x04, 0x00, 
	0x00, 0x00, 0xf8, 0x88, 0x88, 0x80, 0x00, 
	0x00, 0x00, 0x78, 0x86, 0x11, 0xe0, 0x00, 
	0x00, 0x88, 0xf8, 0x88, 0x88, 0x70, 0x00, 
	0x00, 0x00, 0x08, 0xc6, 0x31, 0x8c, 0x5e, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x08, 0x28, 0x91, 0x22, 0x28, 0x50, 0x40, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x08, 0x8c, 0x45, 0x54, 0xaa, 0x55, 0x11, 0x08, 0x80, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x08, 0x28, 0x8a, 0x08, 0x28, 0x8a, 0x08, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x08, 0x28, 0x91, 0x14, 0x28, 0x20, 0x40, 0x8e, 0x00, 0x00, 
	0x00, 0x00, 0xf1, 0x24, 0x48, 0xf0, 0x00, 
	0x05, 0x24, 0xa2, 0x49, 0x22, 0x00, 
	0x7f, 0xf8, 
	0x11, 0x24, 0x8a, 0x49, 0x28, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x06, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

const FONT_CHAR_INFO ubuntu10ptCharDescriptors[] = {
	{2, 0},	// 0x20  32  
	{1, 4},	// 0x21  33 !
	{3, 6},	// 0x22  34 "
	{7, 12},	// 0x23  35 #
	{5, 25},	// 0x24  36 $
	{9, 34},	// 0x25  37 %
	{7, 50},	// 0x26  38 &
	{1, 63},	// 0x27  39 '
	{3, 65},	// 0x28  40 (
	{3, 71},	// 0x29  41 )
	{5, 77},	// 0x2a  42 *
	{5, 86},	// 0x2b  43 +
	{2, 95},	// 0x2c  44 ,
	{3, 99},	// 0x2d  45 -
	{1, 105},	// 0x2e  46 .
	{5, 107},	// 0x2f  47 /
	{5, 116},	// 0x30  48 0
	{3, 125},	// 0x31  49 1
	{5, 131},	// 0x32  50 2
	{5, 140},	// 0x33  51 3
	{5, 149},	// 0x34  52 4
	{5, 158},	// 0x35  53 5
	{5, 167},	// 0x36  54 6
	{5, 176},	// 0x37  55 7
	{5, 185},	// 0x38  56 8
	{5, 194},	// 0x39  57 9
	{1, 203},	// 0x3a  58 :
	{2, 205},	// 0x3b  59 ;
	{5, 209},	// 0x3c  60 <
	{6, 218},	// 0x3d  61 =
	{5, 229},	// 0x3e  62 >
	{4, 238},	// 0x3f  63 ?
	{10, 245},	// 0x40  64 @
	{9, 263},	// 0x41  65 A
	{6, 279},	// 0x42  66 B
	{7, 290},	// 0x43  67 C
	{7, 303},	// 0x44  68 D
	{5, 316},	// 0x45  69 E
	{6, 325},	// 0x46  70 F
	{7, 336},	// 0x47  71 G
	{7, 349},	// 0x48  72 H
	{1, 362},	// 0x49  73 I
	{6, 364},	// 0x4a  74 J
	{7, 375},	// 0x4b  75 K
	{6, 388},	// 0x4c  76 L
	{9, 399},	// 0x4d  77 M
	{7, 415},	// 0x4e  78 N
	{8, 428},	// 0x4f  79 O
	{7, 442},	// 0x50  80 P
	{8, 455},	// 0x51  81 Q
	{7, 469},	// 0x52  82 R
	{5, 482},	// 0x53  83 S
	{7, 491},	// 0x54  84 T
	{7, 504},	// 0x55  85 U
	{9, 517},	// 0x56  86 V
	{11, 533},	// 0x57  87 W
	{7, 553},	// 0x58  88 X
	{7, 566},	// 0x59  89 Y
	{5, 579},	// 0x5a  90 Z
	{3, 588},	// 0x5b  91 [
	{5, 594},	// 0x5c  92 backslash
	{3, 603},	// 0x5d  93 ]
	{7, 609},	// 0x5e  94 ^
	{6, 622},	// 0x5f  95 _
	{2, 633},	// 0x60  96 `
	{5, 637},	// 0x61  97 a
	{6, 646},	// 0x62  98 b
	{5, 657},	// 0x63  99 c
	{6, 666},	// 0x64 100 d
	{6, 677},	// 0x65 101 e
	{4, 688},	// 0x66 102 f
	{6, 695},	// 0x67 103 g
	{6, 706},	// 0x68 104 h
	{1, 717},	// 0x69 105 i
	{3, 719},	// 0x6a 106 j
	{5, 725},	// 0x6b 107 k
	{3, 734},	// 0x6c 108 l
	{9, 740},	// 0x6d 109 m
	{5, 756},	// 0x6e 110 n
	{6, 765},	// 0x6f 111 o
	{6, 776},	// 0x70 112 p
	{6, 787},	// 0x71 113 q
	{4, 798},	// 0x72 114 r
	{4, 805},	// 0x73 115 s
	{4, 812},	// 0x74 116 t
	{5, 819},	// 0x75 117 u
	{7, 828},	// 0x76 118 v
	{9, 841},	// 0x77 119 w
	{7, 857},	// 0x78 120 x
	{7, 870},	// 0x79 121 y
	{4, 883},	// 0x7a 122 z
	{3, 890},	// 0x7b 123 {
	{1, 896},	// 0x7c 124 |
	{3, 898},	// 0x7d 125 }
	{6, 904},	// 0x7e 126 ~
};

// Font information for Ubuntu 10pt
const FONT_INFO ubuntu10ptFontInfo =
{
	13,	// Character height
	' ',	// The first character available
	126,	// The last character available
	FONT_PACKEDDATA,	// Character flags
	ubuntu10ptCharDescriptors,	// Character decriptor array
	ubuntu10ptCharBitmaps,	// Character bitmap array
};

