//------------------------------------------------------------------------------
// Файл		: mylib.c
// Создан	: 12.03.2011
// Автор	: Панзыга П.П.
// Описание	: Реализация вспомогательных средств
// Copyright (c) 2011
//------------------------------------------------------------------------------

#include "mylib.h"

void memset(uint8_t* dst, uint8_t c, int n) {
	while(n--) { *dst++ = c; }
}

void memcpy(uint8_t* dst, uint8_t* src, int n) {
	while(n--) { *dst++ = *src++; }
}

uint32_t rand()
{
	static uint32_t val = 1234567890;
	const uint32_t A = 3567;
	const uint32_t C = 1793;
	val = A * val + C;
	return val;
}

char* itoa(int value, char *str, int base) {
	if(!str) return 0;
	if(value == 0) {
		str[0] = '0';
		str[1] = '\0';
		return str;
	}
	char buff[16];
	int n = 0;
	int sig = 0;
	if(value < 0) {
		sig = 1;
		value = -value;
	}
	int left;
	while(value && n < 15) {
		left = value % base;
		value = value / base;
		buff[n++] = left + (left < 10 ? '0' : 'A' - 10);
	}
	if(sig) buff[n++] = '-';
	n--;
	for(left = 0; left <= n; left++) {
		str[left] = buff[n - left];
	}
	str[left] = '\0';
	return str;
}

char* ttoa(uint32_t time, char *str) {
	if(!str) return 0;
	uint8_t n = 0;
	uint32_t v;
	if(time > (24*60*60*1000)) {
		itoa(time / (24*60*60*1000), str, 10);
		time %= 24*60*60*1000;
		while(str[n])n++;
		str[n++] = ' ';
	}
	v = time / (60*60*1000);
	time %= 60*60*1000;
	str[n++] = '0' + v/10;
	str[n++] = '0' + v%10;
	str[n++] = ':';
	v = time / (60*1000);
	time %= 60*1000;
	str[n++] = '0' + v/10;
	str[n++] = '0' + v%10;
	str[n++] = ':';
	v = time / 1000;
	time %= 1000;
	str[n++] = '0' + v/10;
	str[n++] = '0' + v%10;
	str[n++] = '.';
	str[n++] = '0' + time/100;
	str[n++] = '0' + (time/10)%10;
	str[n++] = '0' + time%10;
	str[n++] = 0;
	return str;
}

//  Name  : CRC-8
//  Poly  : 0x31    x^8 + x^5 + x^4 + 1
//  Revert: false
//  XorOut: 0x00
//  Check : 0xF7 ("123456789")
//  MaxLen: 15 байт(127 бит) - обнаружение одинарных, двойных, тройных и всех нечетных ошибок
unsigned char crc8(const uint8_t *pData, uint8_t len, uint8_t crc)
{
    uint8_t i;
    while (len--) {
        crc ^= *pData++;
        for (i = 0; i < 8; i++) {
            crc = crc & 0x80 ? (crc << 1) ^ 0x31 : crc << 1;
        }
    }
    return crc;
}

//  Name  : CRC-16 CCITT
//  Poly  : 0x1021    x^16 + x^12 + x^5 + 1
//  Revert: false
//  XorOut: 0x0000
//  MaxLen: 4095 байт (32767 бит) - обнаружение одинарных, двойных, тройных и всех нечетных ошибок
uint16_t crc16(const uint8_t *pData, uint16_t len, uint16_t crc)
{
	uint8_t i;
    while (len--) {
        crc ^= *pData++ << 8;
        for (i = 0; i < 8; i++) {
            crc = crc & 0x8000 ? (crc << 1) ^ 0x1021 : crc << 1;
        }
    }
    return crc;
}

