//------------------------------------------------------------------------------
// Файл		: font5x8.c
// Создан	: 06.07.2011
// Автор	: Панзыга П.П.
// Описание	: Реализация моноширинного шрифта 5x8 в кодировке windows-1251.
// Copyright (c) 2011
//------------------------------------------------------------------------------

#include <stdint.h>
#include "font.h"

// Font data for font 5x8 windows-1251
const uint8_t font5x8pxCharBitmaps[] = {
	0x00, 0x00, 0x00, 0x00, 0x00,	// 0x00   0 .
	0x02, 0x94, 0x08, 0xb8, 0x00,	// 0x01   1 .
	0x77, 0xeb, 0xfa, 0xed, 0xc0,	// 0x02   2 .
	0x02, 0xbf, 0xff, 0xb8, 0x80,	// 0x03   3 .
	0x01, 0x1d, 0xff, 0xb8, 0x80,	// 0x04   4 .
	0x21, 0x3e, 0x42, 0x11, 0xc0,	// 0x05   5 .
	0x23, 0xbf, 0xf7, 0x11, 0xc0,	// 0x06   6 .
	0x03, 0xbf, 0xff, 0xb8, 0x00,	// 0x07   7 .
	0xff, 0xf7, 0x18, 0xef, 0xff,	// 0x08   8 .
	0x01, 0x05, 0xf1, 0x10, 0x00,	// 0x09   9 .
	0x09, 0x5b, 0xf6, 0x10, 0x00,	// 0x0a  10 .
	0x18, 0x48, 0xc9, 0x49, 0x80,	// 0x0b  11 .
	0x74, 0x62, 0xe2, 0x38, 0x80,	// 0x0c  12 .
	0x01, 0x19, 0xf6, 0x10, 0x00,	// 0x0d  13 .
	0x62, 0x92, 0x9c, 0xec, 0x60,	// 0x0e  14 .
	0x01, 0x1d, 0xb7, 0x10, 0x00,	// 0x0f  15 .
	0x43, 0x1c, 0xf7, 0x31, 0x00,	// 0x10  16 .
	0x11, 0x9d, 0xe7, 0x18, 0x40,	// 0x11  17 .
	0x23, 0xbe, 0x4f, 0xb8, 0x80,	// 0x12  18 .
	0x52, 0x94, 0xa5, 0x01, 0x40,	// 0x13  19 .
	0x7f, 0x7a, 0xd2, 0x94, 0xa0,	// 0x14  20 .
	0x3a, 0x08, 0xa2, 0x0b, 0x80,	// 0x15  21 .
	0x00, 0x3f, 0xff, 0xff, 0xe0,	// 0x16  22 .
	0x23, 0xbe, 0x4f, 0xb8, 0x9f,	// 0x17  23 .
	0x23, 0xbe, 0x42, 0x10, 0x80,	// 0x18  24 .
	0x21, 0x08, 0x4f, 0xb8, 0x80,	// 0x19  25 .
	0x00, 0x00, 0x00, 0x00, 0x00,	// 0x1a  26 .
	0x01, 0x11, 0xf4, 0x10, 0x00,	// 0x1b  27 .
	0x04, 0x21, 0xf0, 0x00, 0x00,	// 0x1c  28 .
	0x00, 0x15, 0xf5, 0x00, 0x00,	// 0x1d  29 .
	0x01, 0x1d, 0xff, 0x80, 0x00,	// 0x1e  30 .
	0x00, 0x01, 0xff, 0xb8, 0x80,	// 0x1f  31 .
	0x00, 0x00, 0x00, 0x00, 0x00,	// 0x20  32  
	0x21, 0x08, 0x42, 0x00, 0x80,	// 0x21  33 !
	0x52, 0x94, 0x00, 0x00, 0x00,	// 0x22  34 "
	0x52, 0xbe, 0xaf, 0xa9, 0x40,	// 0x23  35 #
	0x23, 0xe8, 0xe2, 0xf8, 0x80,	// 0x24  36 $
	0xc6, 0x44, 0x44, 0x4c, 0x60,	// 0x25  37 %
	0x64, 0xa8, 0x8a, 0xc9, 0xa0,	// 0x26  38 &
	0x61, 0x10, 0x00, 0x00, 0x00,	// 0x27  39 '
	0x11, 0x10, 0x84, 0x10, 0x40,	// 0x28  40 (
	0x41, 0x04, 0x21, 0x11, 0x00,	// 0x29  41 )
	0x02, 0x89, 0xf2, 0x28, 0x00,	// 0x2a  42 *
	0x01, 0x09, 0xf2, 0x10, 0x00,	// 0x2b  43 +
	0x00, 0x00, 0x06, 0x11, 0x00,	// 0x2c  44 ,
	0x00, 0x01, 0xf0, 0x00, 0x00,	// 0x2d  45 -
	0x00, 0x00, 0x00, 0x31, 0x80,	// 0x2e  46 .
	0x00, 0x44, 0x44, 0x40, 0x00,	// 0x2f  47 /
	0x74, 0x67, 0x5c, 0xc5, 0xc0,	// 0x30  48 0
	0x23, 0x08, 0x42, 0x11, 0xc0,	// 0x31  49 1
	0x74, 0x42, 0x22, 0x23, 0xe0,	// 0x32  50 2
	0xf8, 0x88, 0x20, 0xc5, 0xc0,	// 0x33  51 3
	0x11, 0x95, 0x2f, 0x88, 0x40,	// 0x34  52 4
	0xfc, 0x3c, 0x10, 0xc5, 0xc0,	// 0x35  53 5
	0x32, 0x21, 0xe8, 0xc5, 0xc0,	// 0x36  54 6
	0xf8, 0x44, 0x44, 0x21, 0x00,	// 0x37  55 7
	0x74, 0x62, 0xe8, 0xc5, 0xc0,	// 0x38  56 8
	0x74, 0x62, 0xf0, 0x89, 0x80,	// 0x39  57 9
	0x03, 0x18, 0x06, 0x30, 0x00,	// 0x3a  58 :
	0x03, 0x18, 0x06, 0x11, 0x00,	// 0x3b  59 ;
	0x08, 0x88, 0x82, 0x08, 0x20,	// 0x3c  60 <
	0x00, 0x3e, 0x0f, 0x80, 0x00,	// 0x3d  61 =
	0x82, 0x08, 0x22, 0x22, 0x00,	// 0x3e  62 >
	0x74, 0x42, 0x22, 0x00, 0x80,	// 0x3f  63 ?
	0x74, 0x42, 0xda, 0xd5, 0xc0,	// 0x40  64 @
	0x74, 0x63, 0x1f, 0xc6, 0x20,	// 0x41  65 A
	0xf4, 0x63, 0xe8, 0xc7, 0xc0,	// 0x42  66 B
	0x74, 0x61, 0x08, 0x45, 0xc0,	// 0x43  67 C
	0xe4, 0xa3, 0x18, 0xcb, 0x80,	// 0x44  68 D
	0xfc, 0x21, 0xe8, 0x43, 0xe0,	// 0x45  69 E
	0xfc, 0x21, 0xc8, 0x42, 0x00,	// 0x46  70 F
	0x74, 0x61, 0x09, 0xc5, 0xc0,	// 0x47  71 G
	0x8c, 0x63, 0xf8, 0xc6, 0x20,	// 0x48  72 H
	0x71, 0x08, 0x42, 0x11, 0xc0,	// 0x49  73 I
	0x38, 0x84, 0x21, 0x49, 0x80,	// 0x4a  74 J
	0x8c, 0xa9, 0x8a, 0x4a, 0x20,	// 0x4b  75 K
	0x84, 0x21, 0x08, 0x43, 0xe0,	// 0x4c  76 L
	0x8e, 0xeb, 0x18, 0xc6, 0x20,	// 0x4d  77 M
	0x8c, 0x73, 0x59, 0xc6, 0x20,	// 0x4e  78 N
	0x74, 0x63, 0x18, 0xc5, 0xc0,	// 0x4f  79 O
	0xf4, 0x63, 0xe8, 0x42, 0x00,	// 0x50  80 P
	0x74, 0x63, 0x1a, 0xc9, 0xa0,	// 0x51  81 Q
	0xf4, 0x63, 0xea, 0x4a, 0x20,	// 0x52  82 R
	0x7c, 0x20, 0xe0, 0x87, 0xc0,	// 0x53  83 S
	0xf9, 0x08, 0x42, 0x10, 0x80,	// 0x54  84 T
	0x8c, 0x63, 0x18, 0xc5, 0xc0,	// 0x55  85 U
	0x8c, 0x63, 0x18, 0xa8, 0x80,	// 0x56  86 V
	0x8c, 0x63, 0x5a, 0xee, 0x20,	// 0x57  87 W
	0x8c, 0x54, 0x45, 0x46, 0x20,	// 0x58  88 X
	0x8c, 0x54, 0x42, 0x10, 0x80,	// 0x59  89 Y
	0xf8, 0x44, 0x44, 0x43, 0xe0,	// 0x5a  90 Z
	0x39, 0x08, 0x42, 0x10, 0xe0,	// 0x5b  91 [
	0x04, 0x10, 0x41, 0x04, 0x00,	// 0x5c  92 backslash
	0xe1, 0x08, 0x42, 0x13, 0x80,	// 0x5d  93 ]
	0x22, 0xa2, 0x00, 0x00, 0x00,	// 0x5e  94 ^
	0x00, 0x00, 0x00, 0x03, 0xe0,	// 0x5f  95 _
	0x41, 0x04, 0x00, 0x00, 0x00,	// 0x60  96 `
	0x00, 0x1c, 0x17, 0xc5, 0xe0,	// 0x61  97 a
	0x84, 0x2d, 0x98, 0xc7, 0xc0,	// 0x62  98 b
	0x00, 0x1d, 0x08, 0x45, 0xc0,	// 0x63  99 c
	0x08, 0x5b, 0x38, 0xc5, 0xe0,	// 0x64 100 d
	0x00, 0x1d, 0x1f, 0xc1, 0xc0,	// 0x65 101 e
	0x32, 0x51, 0xc4, 0x21, 0x00,	// 0x66 102 f
	0x00, 0x1f, 0x17, 0x84, 0xc0,	// 0x67 103 g
	0x84, 0x2d, 0x98, 0xc6, 0x20,	// 0x68 104 h
	0x20, 0x18, 0x42, 0x11, 0xc0,	// 0x69 105 i
	0x10, 0x0c, 0x21, 0x49, 0x80,	// 0x6a 106 j
	0x42, 0x12, 0xa6, 0x29, 0x20,	// 0x6b 107 k
	0x61, 0x08, 0x42, 0x11, 0xc0,	// 0x6c 108 l
	0x00, 0x35, 0x5a, 0xc6, 0x20,	// 0x6d 109 m
	0x00, 0x2d, 0x98, 0xc6, 0x20,	// 0x6e 110 n
	0x00, 0x1d, 0x18, 0xc5, 0xc0,	// 0x6f 111 o
	0x00, 0x3d, 0x1f, 0x42, 0x00,	// 0x70 112 p
	0x00, 0x1b, 0x37, 0x84, 0x20,	// 0x71 113 q
	0x00, 0x2d, 0x98, 0x42, 0x00,	// 0x72 114 r
	0x00, 0x1d, 0x07, 0x07, 0xc0,	// 0x73 115 s
	0x42, 0x38, 0x84, 0x24, 0xc0,	// 0x74 116 t
	0x00, 0x23, 0x18, 0xcd, 0xa0,	// 0x75 117 u
	0x00, 0x23, 0x18, 0xa8, 0x80,	// 0x76 118 v
	0x00, 0x23, 0x1a, 0xd5, 0x40,	// 0x77 119 w
	0x00, 0x22, 0xa2, 0x2a, 0x20,	// 0x78 120 x
	0x00, 0x23, 0x17, 0x85, 0xc0,	// 0x79 121 y
	0x00, 0x3e, 0x22, 0x23, 0xe0,	// 0x7a 122 z
	0x11, 0x08, 0x82, 0x10, 0x40,	// 0x7b 123 {
	0x21, 0x08, 0x42, 0x10, 0x80,	// 0x7c 124 |
	0x41, 0x08, 0x22, 0x11, 0x00,	// 0x7d 125 }
	0x02, 0x2a, 0x20, 0x00, 0x00,	// 0x7e 126 ~
	0xfc, 0x63, 0x18, 0xc7, 0xe0,	// 0x7f 127 
	0xe2, 0x14, 0xd4, 0xa5, 0x40,	// 0x80 128 �
	0x11, 0x3e, 0x94, 0x23, 0x80,	// 0x81 129 �
	0x00, 0x00, 0x03, 0x08, 0x80,	// 0x82 130 �
	0x11, 0x00, 0xe4, 0x21, 0x00,	// 0x83 131 �
	0x00, 0x00, 0x0d, 0xa6, 0x40,	// 0x84 132 �
	0x00, 0x00, 0x00, 0x02, 0xa0,	// 0x85 133 �
	0x27, 0xc8, 0x42, 0x10, 0x80,	// 0x86 134 �
	0x27, 0xc8, 0x42, 0x7c, 0x80,	// 0x87 135 �
	0x32, 0x78, 0x8e, 0x24, 0xc0,	// 0x88 136 �
	0x8c, 0x88, 0x88, 0x14, 0xa0,	// 0x89 137 �
	0x65, 0x29, 0x6a, 0xd6, 0xc0,	// 0x8a 138 �
	0x11, 0x0c, 0x00, 0x00, 0x00,	// 0x8b 139 �
	0xa5, 0x29, 0xea, 0xd6, 0xc0,	// 0x8c 140 �
	0x15, 0x63, 0x2e, 0x4a, 0x20,	// 0x8d 141 �
	0xe2, 0x10, 0xa6, 0xa5, 0x20,	// 0x8e 142 �
	0x8c, 0x63, 0x18, 0xfc, 0x80,	// 0x8f 143 �
	0x47, 0x10, 0xe4, 0xa4, 0x40,	// 0x90 144 �
	0x11, 0x0c, 0x00, 0x00, 0x00,	// 0x91 145 �
	0x61, 0x10, 0x00, 0x00, 0x00,	// 0x92 146 �
	0x4c, 0xb6, 0x00, 0x00, 0x00,	// 0x93 147 �
	0xda, 0x64, 0x00, 0x00, 0x00,	// 0x94 148 �
	0x03, 0xbf, 0xff, 0xb8, 0x00,	// 0x95 149 �
	0x00, 0x00, 0xe0, 0x00, 0x00,	// 0x96 150 �
	0x00, 0x01, 0xf0, 0x00, 0x00,	// 0x97 151 �
	0x74, 0x42, 0x22, 0x00, 0x80,	// 0x98 152 ?
	0xf9, 0x09, 0x1d, 0xd6, 0x20,	// 0x99 153 �
	0x00, 0x19, 0x4b, 0x56, 0xc0,	// 0x9a 154 �
	0x41, 0x18, 0x00, 0x00, 0x00,	// 0x9b 155 �
	0x00, 0x29, 0x4f, 0x56, 0xc0,	// 0x9c 156 �
	0x11, 0x21, 0x4c, 0x52, 0x40,	// 0x9d 157 �
	0x47, 0x10, 0xa6, 0xa5, 0x20,	// 0x9e 158 �
	0x00, 0x23, 0x18, 0xfc, 0x80,	// 0x9f 159 �
	0x00, 0x00, 0x00, 0x00, 0x00,	// 0xa0 160 �
	0x51, 0x23, 0x15, 0x11, 0x10,	// 0xa1 161 �
	0x02, 0x89, 0x15, 0x11, 0x10,	// 0xa2 162 �
	0x38, 0x84, 0x2d, 0x69, 0x80,	// 0xa3 163 �
	0x00, 0x2a, 0xa5, 0x54, 0x00,	// 0xa4 164 �
	0x0f, 0xd0, 0x84, 0x23, 0x80,	// 0xa5 165 �
	0x21, 0x08, 0x02, 0x10, 0x80,	// 0xa6 166 �
	0x32, 0x08, 0xa2, 0x09, 0x80,	// 0xa7 167 �
	0x57, 0xe1, 0xe8, 0x43, 0xe0,	// 0xa8 168 �
	0x74, 0x6f, 0x9c, 0xde, 0x2e,	// 0xa9 169 �
	0x74, 0x79, 0x08, 0xc5, 0xc0,	// 0xaa 170 �
	0x01, 0x13, 0x24, 0x90, 0x00,	// 0xab 171 �
	0x00, 0x01, 0xf0, 0x80, 0x00,	// 0xac 172 �
	0x00, 0x01, 0xf0, 0x00, 0x00,	// 0xad 173 �
	0x74, 0x7b, 0xbe, 0xee, 0x2e,	// 0xae 174 �
	0x57, 0xc8, 0x42, 0x13, 0xe0,	// 0xaf 175 �
	0x72, 0x9c, 0x00, 0x00, 0x00,	// 0xb0 176 �
	0x01, 0x1c, 0x40, 0x38, 0x00,	// 0xb1 177 �
	0x71, 0x08, 0x42, 0x11, 0xc0,	// 0xb2 178 �
	0x20, 0x18, 0x42, 0x11, 0xc0,	// 0xb3 179 �
	0x00, 0x05, 0xe4, 0x21, 0x00,	// 0xb4 180 �
	0x00, 0x23, 0xba, 0xc2, 0x00,	// 0xb5 181 �
	0x7d, 0x6a, 0xd2, 0x94, 0xa0,	// 0xb6 182 �
	0x00, 0x00, 0x40, 0x00, 0x00,	// 0xb7 183 �
	0x50, 0x1d, 0x1f, 0xc1, 0xc0,	// 0xb8 184 �
	0x18, 0xe1, 0x2d, 0x5a, 0x40,	// 0xb9 185 �
	0x00, 0x1d, 0x0e, 0x45, 0xc0,	// 0xba 186 �
	0x01, 0x24, 0x99, 0x10, 0x00,	// 0xbb 187 �
	0x00, 0x98, 0x42, 0x51, 0x00,	// 0xbc 188 �
	0x7c, 0x20, 0xe0, 0x87, 0xc0,	// 0xbd 189 �
	0x00, 0x1d, 0x07, 0x07, 0xc0,	// 0xbe 190 �
	0x50, 0x18, 0x42, 0x11, 0xc0,	// 0xbf 191 �
	0x74, 0x63, 0x1f, 0xc6, 0x20,	// 0xc0 192 �
	0xf4, 0x21, 0xe8, 0xc7, 0xc0,	// 0xc1 193 �
	0xf4, 0x63, 0xe8, 0xc7, 0xc0,	// 0xc2 194 �
	0xfc, 0x21, 0x08, 0x42, 0x00,	// 0xc3 195 �
	0x32, 0x94, 0xa5, 0x7e, 0x20,	// 0xc4 196 �
	0xfc, 0x21, 0xe8, 0x43, 0xe0,	// 0xc5 197 �
	0xad, 0x6a, 0xe7, 0x56, 0xa0,	// 0xc6 198 �
	0x74, 0x42, 0x60, 0xc5, 0xc0,	// 0xc7 199 �
	0x8c, 0x67, 0x5c, 0xc6, 0x20,	// 0xc8 200 �
	0xac, 0x67, 0x5c, 0xc6, 0x20,	// 0xc9 201 �
	0x8c, 0xa9, 0x8a, 0x4a, 0x20,	// 0xca 202 �
	0x32, 0x52, 0x94, 0xa6, 0x20,	// 0xcb 203 �
	0x8e, 0xeb, 0x18, 0xc6, 0x20,	// 0xcc 204 �
	0x8c, 0x63, 0xf8, 0xc6, 0x20,	// 0xcd 205 �
	0x74, 0x63, 0x18, 0xc5, 0xc0,	// 0xce 206 �
	0xfc, 0x63, 0x18, 0xc6, 0x20,	// 0xcf 207 �
	0xf4, 0x63, 0xe8, 0x42, 0x00,	// 0xd0 208 �
	0x74, 0x61, 0x08, 0x45, 0xc0,	// 0xd1 209 �
	0xf9, 0x08, 0x42, 0x10, 0x80,	// 0xd2 210 �
	0x8c, 0x62, 0xf0, 0xc5, 0xc0,	// 0xd3 211 �
	0x75, 0x6b, 0x5a, 0xb8, 0x80,	// 0xd4 212 �
	0x8c, 0x54, 0x45, 0x46, 0x20,	// 0xd5 213 �
	0x94, 0xa5, 0x29, 0x78, 0x20,	// 0xd6 214 �
	0x8c, 0x63, 0x1f, 0x84, 0x20,	// 0xd7 215 �
	0xad, 0x6b, 0x5a, 0xd7, 0xe0,	// 0xd8 216 �
	0xad, 0x6b, 0x5a, 0xfc, 0x20,	// 0xd9 217 �
	0xc2, 0x1c, 0x94, 0xa5, 0xc0,	// 0xda 218 �
	0x8c, 0x7b, 0x5a, 0xd7, 0xa0,	// 0xdb 219 �
	0x84, 0x3d, 0x18, 0xc7, 0xc0,	// 0xdc 220 �
	0x74, 0x42, 0x70, 0xc5, 0xc0,	// 0xdd 221 �
	0xbd, 0x6b, 0xda, 0xd6, 0xe0,	// 0xde 222 �
	0x7c, 0x62, 0xf2, 0xa6, 0x20,	// 0xdf 223 �
	0x00, 0x1c, 0x17, 0xc5, 0xe0,	// 0xe0 224 �
	0x13, 0xa1, 0xe8, 0xc5, 0xc0,	// 0xe1 225 �
	0x00, 0x39, 0x2f, 0x47, 0xc0,	// 0xe2 226 �
	0x00, 0x3f, 0x08, 0x42, 0x00,	// 0xe3 227 �
	0x00, 0x0c, 0xa5, 0x7e, 0x20,	// 0xe4 228 �
	0x00, 0x1d, 0x1f, 0xc1, 0xc0,	// 0xe5 229 �
	0x00, 0x2a, 0xea, 0xd6, 0xa0,	// 0xe6 230 �
	0x00, 0x1d, 0x13, 0x45, 0xc0,	// 0xe7 231 �
	0x00, 0x23, 0x3a, 0xe6, 0x20,	// 0xe8 232 �
	0x51, 0x23, 0x3a, 0xe6, 0x20,	// 0xe9 233 �
	0x00, 0x23, 0x2e, 0x4a, 0x20,	// 0xea 234 �
	0x00, 0x0e, 0x94, 0xa7, 0x20,	// 0xeb 235 �
	0x00, 0x23, 0xba, 0xc6, 0x20,	// 0xec 236 �
	0x00, 0x23, 0x1f, 0xc6, 0x20,	// 0xed 237 �
	0x00, 0x1d, 0x18, 0xc5, 0xc0,	// 0xee 238 �
	0x00, 0x3f, 0x18, 0xc6, 0x20,	// 0xef 239 �
	0x00, 0x3d, 0x1f, 0x42, 0x00,	// 0xf0 240 �
	0x00, 0x1d, 0x18, 0x45, 0xc0,	// 0xf1 241 �
	0x00, 0x3e, 0x42, 0x10, 0x80,	// 0xf2 242 �
	0x00, 0x23, 0x17, 0x85, 0xc0,	// 0xf3 243 �
	0x00, 0x1d, 0x5a, 0xb8, 0x80,	// 0xf4 244 �
	0x00, 0x22, 0xa2, 0x2a, 0x20,	// 0xf5 245 �
	0x00, 0x25, 0x29, 0x78, 0x20,	// 0xf6 246 �
	0x00, 0x23, 0x18, 0xbc, 0x20,	// 0xf7 247 �
	0x00, 0x2b, 0x5a, 0xd7, 0xe0,	// 0xf8 248 �
	0x00, 0x2b, 0x5a, 0xfc, 0x20,	// 0xf9 249 �
	0x00, 0x30, 0xe4, 0xa5, 0xc0,	// 0xfa 250 �
	0x00, 0x23, 0xd9, 0xcf, 0xa0,	// 0xfb 251 �
	0x00, 0x21, 0xe8, 0xc7, 0xc0,	// 0xfc 252 �
	0x00, 0x1d, 0x13, 0xc5, 0xc0,	// 0xfd 253 �
	0x00, 0x2d, 0x9c, 0xe6, 0xc0,	// 0xfe 254 �
	0x00, 0x1f, 0x17, 0xa6, 0x20 	// 0xff 255 �
};

// Font information for font 5x8 pixels
const FONT_INFO font5x8pxFontInfo =
{
	8,	// Character height
	0,	// The first character available
	255,	// The last character available
	FONT_FIXEDWIDTH | FONT_PACKEDDATA,	// Character flags
	MAKECHARDESCRIPTOR(5),	// Character decriptor
	font5x8pxCharBitmaps,	// Character bitmap array
};
