﻿//------------------------------------------------------------------------------
// Файл		: lcdgui.c
// Создан	: 01.07.2011
// Описание	: Реализация графического "интерфейса" для ЖК-дисплея.
//------------------------------------------------------------------------------

#include <stdint.h>
#include "lcd.h"
#include "lcdgui.h"
//#include "mylib.h"

const uint8_t icons8x8[] = {
		0x3C, 0x42, 0x91, 0x95, 0x99, 0x81, 0x42, 0x3C,	// clock
		0x50, 0x50, 0xF8, 0x89, 0x8A, 0x72, 0x24, 0x18,	// connect
		0x3C, 0x5A, 0xA5, 0xDB, 0xDB, 0xA5, 0x5A, 0x3C,	// disk
		0x2A, 0x2A, 0xFF, 0x81, 0xC1, 0xFF, 0x2A, 0x2A,	// flash
		0x66, 0xDB, 0x81, 0x81, 0xC3, 0x42, 0x24, 0x18,	// heart
		0x24, 0x7E, 0x9F, 0xBF, 0xFF, 0x7E, 0x3C, 0x18,	// heart2
		0x7E, 0x42, 0x42, 0x42, 0x7E, 0x00, 0xFF, 0xFF,	// lan
		0x00, 0xFF, 0xC3, 0xA5, 0x99, 0x81, 0xFF, 0x00,	// mail
		0x19, 0x3A, 0xE8, 0xCB, 0xC8, 0xEA, 0x39, 0x18,	// music
		0x18, 0x18, 0x5A, 0x99, 0x99, 0x99, 0x42, 0x3C,	// power
		0x3C, 0x24, 0xFF, 0xFF, 0xC3, 0xC3, 0xFF, 0xFF,	// printer
		0x18, 0x18, 0x18, 0x18, 0xFF, 0x7E, 0x3C, 0x18,	// recive
		0x18, 0x3C, 0x7E, 0xFF, 0x18, 0x18, 0x18, 0x18,	// send
		0x3C, 0x42, 0x99, 0xBD, 0xBD, 0x81, 0x42, 0x3C,	// status
		0x18, 0x34, 0x28, 0x18, 0x66, 0xD5, 0xAB, 0x66,	// wan
		0x18, 0x99, 0xDB, 0x7E, 0x3C, 0x18, 0x18, 0x18,	// wireless
		0x30, 0x64, 0xC9, 0xDA, 0xDA, 0xC9, 0x64, 0x30,	// wireless2
		0x00, 0x00, 0x18, 0x3C, 0x3C, 0x18, 0x00, 0x00,	// point
		0x52, 0x54, 0xF8, 0x99, 0xAA, 0x72, 0xA4, 0x18,	// disconnect
//		0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x,	//
//		0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x,	//
};

void Label(PLabelInfo info) {
	SetFaceColor(info->face);
	SetGroundColor(info->ground);
	SetFont(info->font);
	DrawText((RECT*)info, info->flags, info->text);
}

void Progress(PProgressInfo info) {
	int16_t pos = 0, posex = 0;
	uint16_t height = info->bottom - info->top + 1;
	uint16_t width = info->right - info->left + 1;
	if(info->pos <= 100)
		pos = width * info->pos / 100;
	if(info->posex <= 100)
		posex = width * info->posex / 100;
	if(posex < pos)
		posex = pos;
	if(pos)
		Fill(info->left, info->top, pos, height, info->color);
	if(posex != pos)
		Fill(info->left + pos, info->top, posex - pos, height, info->colorex);
	if(width != posex)
		Fill(info->left + posex, info->top, width - posex, height, info->ground);
}

void Icon(PIconInfo info) {
	if(info->icon >= sizeof(icons8x8)/8) return;
	SetFaceColor(info->color);
	SetGroundColor(info->ground);
	DrawIcon8x8(info->left, info->top, &icons8x8[info->icon * 8]);
}

void Image(PImageInfo info) {
	//DrawImage(info->left, info->top, images[info->image]);
}

/*char* toSpeed(int32_t speed) {
	static char buff[16];
	char *ptr = itoa(8 * speed / 1024, buff, 10);
	while(*ptr) ptr++;
	ptr[0] = 'k';
	ptr[1] = 'b';
	ptr[2] = 0;
	return buff;
}

void Speed(PSpeedView info) {
	RECT rect;
	int16_t top = info->top;
	SetFont(FONT_STANDART);
	// Скорость приёма
	SetFaceColor(info->color);
	SetGroundColor(info->ground);
	RECT_set(rect, 0, top, 29, top + 14);
	DrawText(&rect, DT_VCENTER | DT_FILL, info->name);
	SetFaceColor(info->vcolor);
	SetGroundColor(info->vground);
	rect.left = 30;
	rect.right = 79;
	DrawText(&rect, DT_RIGHT | DT_VCENTER | DT_FILL, toSpeed(info->rx));
	rect.left = 80;
	rect.right = 127;
	DrawText(&rect, DT_RIGHT | DT_VCENTER | DT_FILL, toSpeed(info->arx));
	// Скорость передачи
	SetFaceColor(info->color);
	SetGroundColor(info->ground);
	RECT_set(rect, 0, top + 15, 29, top + 28);
	DrawText(&rect, DT_CENTER | DT_FILL, "TX");
	SetFaceColor(info->vcolor);
	SetGroundColor(info->vground);
	rect.left = 30;
	rect.right = 79;
	DrawText(&rect, DT_RIGHT | DT_VCENTER | DT_FILL, toSpeed(info->tx));
	rect.left = 80;
	rect.right = 127;
	DrawText(&rect, DT_RIGHT | DT_VCENTER | DT_FILL, toSpeed(info->atx));
}*/

/*void Bar(PBarView info) {
	//void Fill(int16_t left, int16_t top, uint16_t width, uint16_t height, uint32_t color);
	RECT rect;
	ProgressInfo prog;
	int16_t top = info->top;
	SetFont(FONT_STANDART);
	// Вывод имени
	SetFaceColor(info->color);
	SetGroundColor(info->ground);
	Fill(0, top, 128, 1, info->ground);
	RECT_set(rect, 0, top + 1, 27, top + 13);
	DrawText(&rect, DT_FILL, info->name);
	Fill(0, top + 14, 128, 1, info->ground);
	// Вывод строки текста
	if(info->value || info->valname[0]) {
		char buff[16];
		RECT_set(rect, 0, top + 15, 39, top + 28);
		DrawText(&rect, DT_RIGHT | DT_FILL, info->valname);
		rect.left = 110;
		rect.right = 127;
		DrawText(&rect, DT_RIGHT | DT_FILL, " KB");
		rect.left = 40;
		rect.right = 109;
		DrawText(&rect, DT_RIGHT | DT_FILL, itoa(info->value / 1024, buff, 10));
	}
	// Вывод шкал
	prog.color	= info->bcolor;
	prog.ground	= info->bground;
	prog.colorex= info->bcolorex;
	prog.left	= 28;
	prog.right	= 127;
	prog.bottom	= top + 13;
	prog.reserved = 0;
	if(info->posex1 != 255 && info->posex2 != 255) {
		Fill(28, top + 7, 100, 1, info->ground);
		// Вторая шкала
		prog.top	= top + 8;
		prog.pos	= info->pos2;
		prog.posex	= info->posex2;
		Progress(&prog);
		prog.bottom	= top + 6;
	}
	// Первая шкала
	prog.top	= top + 1;
	prog.pos	= info->pos1;
	prog.posex	= info->posex1;
	Progress(&prog);
}*/

