﻿//------------------------------------------------------------------------------
// Файл		: lcdgui.h
// Создан	: 01.07.2011
// Описание	: Средства для работы с графическим "интерфейсом" на ЖК-дисплее.
//------------------------------------------------------------------------------

#ifndef LCDGUI_H_
#define LCDGUI_H_

// Константы номеров иконок
#define ICON_CLOCK	0
#define ICON_CONNECT	1
#define ICON_DISK	2
#define ICON_FLASH	3
#define ICON_HEART	4
#define ICON_HEART3	5
#define ICON_LAN	6
#define ICON_MAIL	7
#define ICON_SOUND	8
#define ICON_POWER	9
#define ICON_PRINTER	10
#define ICON_RECIVE	11
#define ICON_SEND	12
#define ICON_STATUS	13
#define ICON_WAN	14
#define ICON_WLAN	15
#define ICON_WIRELESS	16
#define ICON_POINT	17
#define ICON_NOCONNECT	18

#define	BLACK	0x00000000
#define	WHITE	0x00FFFFFF
#define	RED	0x000000FF
#define	GREEN	0x0000FF00
#define	BLUE	0x00FF0000
#define	CYAN	0x00FFFF00
#define	MAGENTA	0x00FF00FF
#define	YELLOW	0x0000FFFF
#define	GRAY	0x00DFDFDF
#define	CHARCOAL_GRAY	0x007F7F7F
#define	SKYBLUE	0x00EBCE87
#define	CLEAR_SKY	0x00FFDF00
#define	DARK_BLUE	0x008B0000
#define	PURPLE	0x00F020C0
#define	EMERALD_GREEN	0x008F7C8F
#define	ROSE_PINK	0x00BE69FF
#define	ADRIATIC_SEA	0x00D0C040
#define	NOBLE	0x00FF80FF
#define	BEIGE	0x0080FFFF

typedef struct _tagLabelInfo {
	int16_t left;
	int16_t top;
	int16_t right;
	int16_t bottom;
	uint32_t face;
	uint32_t ground;
	uint16_t flags;
	uint8_t font;
	uint8_t len;	// не используется
	char text[32];
} LabelInfo, *PLabelInfo;

typedef struct _tagProgressInfo {
	int16_t left;
	int16_t top;
	int16_t right;
	int16_t bottom;
	uint32_t color;
	uint32_t ground;
	uint32_t colorex;
	uint8_t pos;
	uint8_t posex;
	uint16_t reserved;
} ProgressInfo, *PProgressInfo;

typedef struct _tagIconInfo {
	int16_t left;
	int16_t top;
	//int16_t right;
	//int16_t bottom;
	uint32_t color;
	uint32_t ground;
	uint8_t icon;
	uint8_t flags; // tile, align, ... // не используется
	uint16_t reserved;
}IconInfo, *PIconInfo;

typedef struct _tagImageInfo {	// не реализовано
	int16_t left;
	int16_t top;
	//int16_t right;
	//int16_t bottom;
	uint8_t image;
	uint8_t reserved8;
	uint16_t reserved;
}ImageInfo, *PImageInfo;

void Label(PLabelInfo info);
void Progress(PProgressInfo info);
void Icon(PIconInfo info);
//void Image(PImageInfo info);

typedef struct _tagSpeedView {	// не реализовано
	char name[4];		// Имя устройства
	int16_t reserved;
	int16_t top;
	uint32_t color;		// Цвет надписи
	uint32_t ground;	// Цвет общего фона
	uint32_t vcolor;	// Цвет текста значения
	uint32_t vground;	// Цвет фона значения
	int32_t	rx;			// Скорость приёма
	int32_t	arx;		// Средняя скорость приёма
	int32_t	tx;			// Скорость передачи
	int32_t	atx;		// Средняя скорость передачи
} SpeedView, *PSpeedView;

typedef struct _tagBarView {	// не реализовано
	char name[4];		// Имя устройства
	int16_t reserved;
	int16_t top;
	uint32_t color;		// Цвет надписи
	uint32_t ground;	// Цвет общего фона
	uint32_t bcolor;	// Цвет основной секции
	uint32_t bcolorex;	// Цвет дополнительной секции
	uint32_t bground;	// Цвет фона полосы
	uint8_t	pos1;		// Позиция основной секции первой полосы
	uint8_t posex1;		// Позиция дополнительной секции первой пололсы
	uint8_t	pos2;		// Позиция основной секции второй полосы
	uint8_t	posex2;		// Позиция дополнительной секции второй пололсы
	char valname[4];	// Название величины
	uint32_t value;		// Значение
} BarView, *PBarView;

void Speed(PSpeedView info);
void Bar(PBarView info);


#endif /* LCDGUI_H_ */
