﻿//------------------------------------------------------------------------------
// Файл		: lcd.h
// Создан	: 06.03.2011
// Описание	: Средства для работы с ЖК-дисплеем
//------------------------------------------------------------------------------

#ifndef LCD_H_
#define LCD_H_

// Константы номеров шрифтов
#define	FONT_MONOTYPE	0
#define	FONT_STANDART	1
#define	FONT_STRONG	2
#define	FONT_VERDANA	3

// Парамерт flags для DrawText комбинация
#define	DT_DEFAULT	0x00
#define	DT_LEFT		0x00
#define	DT_RIGHT	0x01
#define	DT_CENTER	0x02
#define	DT_VDEFAULT	0x00
#define	DT_TOP		0x00
#define	DT_BOTTOM	0x04
#define	DT_VCENTER	0x08
#define	DT_FILL		0x10
// Прозрачность запланирована, но на данный момент не является необходимой
//#define	DT_TRANSPARENT		0x080

#define	RGB(r, g, b)	(((uint32_t)(r))|((uint32_t)(g)<<8)|((uint32_t)(b)<<16))
#define RECT_set(rect, l, t, r, b) { (rect).left = (l); (rect).top = (t); (rect).right = (r); (rect).bottom = (b); }


typedef struct _tagPOINT {
	int16_t x;
	int16_t y;
} POINT, *PPOINT;

typedef struct _tagRECT {
	int16_t left;
	int16_t top;
	int16_t right;
	int16_t bottom;
} RECT, *PRECT;

typedef struct _tagSIZE {
	int16_t width;
	int16_t height;
} SIZE, *PSIZE;


void LCD_init();

uint32_t BeginDraw(int16_t left, int16_t top, uint16_t width, uint16_t height);
void EndDraw();
void NextPoint(uint32_t color);
void DrawImage(const uint8_t *data, uint16_t len);

uint16_t GetDisplayWidth();
uint16_t GetDisplayHeight();

void SetFont(uint8_t num);
void SetFaceColor(uint32_t color);
void SetGroundColor(uint32_t color);

void Clear(uint32_t color);
void Fill(int16_t left, int16_t top, uint16_t width, uint16_t height, uint32_t color);

void DrawIcon8x8(int16_t x, int16_t y, const uint8_t *data);

uint8_t GetCharWidth(char c);
uint8_t GetFontHeight();
uint16_t GetStringWidth(const char* str);

uint8_t DrawChar(int16_t x, int16_t y, uint8_t c);
uint16_t DrawString(int16_t x, int16_t y, const char *str);
uint16_t DrawText(const RECT *r, uint16_t flags, const char* str);


#endif /* LCD_H_ */
