/*
===============================================================================
 Name        : main.c
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : main definition
===============================================================================
*/

#ifdef __USE_CMSIS
#include "LPC13xx.h"
#endif

void Init(void)
{
	LPC_IOCON->PIO2_0 &= ~(3<<0);	// D0-7
	LPC_IOCON->PIO2_1 &= ~(3<<0);
	LPC_IOCON->PIO2_2 &= ~(3<<0);
	LPC_IOCON->PIO2_3 &= ~(3<<0);
	LPC_IOCON->PIO2_4 &= ~(3<<0);
	LPC_IOCON->PIO2_5 &= ~(3<<0);
	LPC_IOCON->PIO2_6 &= ~(3<<0);
	LPC_IOCON->PIO2_7 &= ~(3<<0);
	LPC_IOCON->PIO3_0 &= ~(3<<0);	// D8-16
	LPC_IOCON->PIO3_1 &= ~(3<<0);
	LPC_IOCON->PIO3_2 &= ~(3<<0);
	LPC_IOCON->PIO3_3 &= ~(3<<0);
	LPC_IOCON->PIO1_4 &= ~(3<<0);
	LPC_IOCON->PIO1_5 &= ~(3<<0);
	LPC_IOCON->PIO1_6 &= ~(3<<0);
	LPC_IOCON->PIO1_7 &= ~(3<<0);
	LPC_IOCON->PIO1_8 &= ~(3<<0);	// CS
	LPC_IOCON->PIO1_9 &= ~(3<<0);	// RS
	LPC_IOCON->PIO1_10 &= ~(3<<0);	// WR
	LPC_IOCON->PIO0_6 &= ~(3<<0);	// RST

	LPC_GPIO0->DIR |= 1<<6;
	LPC_GPIO0->DATA |= 1<<6;
	LPC_GPIO1->DIR |= 0x07F0;
	LPC_GPIO1->DATA |= 0x07F0;
	LPC_GPIO2->DIR |= 0x00FF;
	LPC_GPIO2->DATA |= 0x00FF;
	LPC_GPIO3->DIR |= 0x000F;
	LPC_GPIO3->DATA |= 0x000F;
}

void delayms(int count)  // /* X1ms */
{
        volatile int i,j;
        for(i=0;i<count;i++)
                for(j=0;j<3000;j++);
}

void main_Write_COM( int  DH)
{
	//LCD_RS=0;
	LPC_GPIO1->DATA &= ~(1<<9);
	//LCD_CS =0;
	LPC_GPIO1->DATA &= ~(1<<8);
	//P2=DH>>8;
	//P0=DH;
	LPC_GPIO2->DATA &= 0xFF00;
	LPC_GPIO2->DATA |= DH & 0x00FF;
	DH >>= 8;
	LPC_GPIO1->DATA &= 0xFF0F;
	LPC_GPIO1->DATA |= DH & 0x00F0;
	LPC_GPIO3->DATA &= 0xFFF0;
	LPC_GPIO3->DATA |= DH & 0x000F;
	//LCD_WR=0;
	// добавить nop
	LPC_GPIO1->DATA &= ~(1<<10);
	//LCD_WR=1;
	// добавить nop
	LPC_GPIO1->DATA |= 1<<10;
	//LCD_CS =1;
	LPC_GPIO1->DATA |= 1<<8;
}

void main_Write_DATA(int DH)
{
	//LCD_RS=1;
	LPC_GPIO1->DATA |= 1<<9;
	//LCD_CS =0;
	LPC_GPIO1->DATA &= ~(1<<8);
	//P2=DH>>8;
	//P0=DH;
	LPC_GPIO2->DATA &= 0xFF00;
	LPC_GPIO2->DATA |= DH & 0x00FF;
	DH >>= 8;
	LPC_GPIO1->DATA &= 0xFF0F;
	LPC_GPIO1->DATA |= DH & 0x00F0;
	LPC_GPIO3->DATA &= 0xFFF0;
	LPC_GPIO3->DATA |= DH & 0x000F;
	//LCD_WR=0;
	// добавить nop
	LPC_GPIO1->DATA &= ~(1<<10);
	//LCD_WR=1;
	// добавить nop
	LPC_GPIO1->DATA |= 1<<10;
	//LCD_CS =1;
	LPC_GPIO1->DATA |= 1<<8;
}

void main_W_com_data( int com1, int dat1)
{
   main_Write_COM(com1);
   main_Write_DATA(dat1);
}

void address_set(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2)
{
	main_W_com_data(0x0002,x1>>8);	   // Column address start2
	main_W_com_data(0x0003,x1);	   // Column address start1
	main_W_com_data(0x0004,x2>>8);	   // Column address end2
	main_W_com_data(0x0005,x2);	   // Column address end1
	main_W_com_data(0x0006,y1>>8);	   // Row address start2
	main_W_com_data(0x0007,y1);	   // Row address start1
    main_W_com_data(0x0008,y2>>8);	   // Row address end2
	main_W_com_data(0x0009,y2);	   // Row address end1
    main_Write_COM(0x0022);

}

void main_init(void)
{

    //LCD_REST=1;
	LPC_GPIO0->DATA |= 1<<6;
    delayms(5);
	//LCD_REST=0;
	LPC_GPIO0->DATA &= ~(1<<6);
	delayms(10);
	//LCD_REST=1;
	LPC_GPIO0->DATA |= 1<<6;
	delayms(20);

	   //  VENDOR
	main_W_com_data(0x0046,0x00A4);
	main_W_com_data(0x0047,0x0053);
	main_W_com_data(0x0048,0x0000);
	main_W_com_data(0x0049,0x0044);
	main_W_com_data(0x004a,0x0004);
	main_W_com_data(0x004b,0x0067);
	main_W_com_data(0x004c,0x0033);
	main_W_com_data(0x004d,0x0077);
	main_W_com_data(0x004e,0x0012);
	main_W_com_data(0x004f,0x004C);
	main_W_com_data(0x0050,0x0046);
	main_W_com_data(0x0051,0x0044);

	  //240x320 window setting
    main_W_com_data(0x0002,0x0000); // Column address start2
 	main_W_com_data(0x0003,0x0000); // Column address start1
 	main_W_com_data(0x0004,0x0000); // Column address end2
 	main_W_com_data(0x0005,0x00ef); // Column address end1
    main_W_com_data(0x0006,0x0000); // Row address start2
	main_W_com_data(0x0007,0x0000); // Row address start1
	main_W_com_data(0x0008,0x0001); // Row address end2
	main_W_com_data(0x0009,0x003f); // Row address end1

  // Display Setting
	main_W_com_data(0x0001,0x0006); // IDMON=0, INVON=1, NORON=1, PTLON=0
	main_W_com_data(0x0016,0x00C8); // MY=0, MX=0, MV=0, ML=1, BGR=0, TEON=0   0048
	main_W_com_data(0x0023,0x0095); // N_DC=1001 0101
	main_W_com_data(0x0024,0x0095); // PI_DC=1001 0101
	main_W_com_data(0x0025,0x00FF); // I_DC=1111 1111

	main_W_com_data(0x0027,0x0002); // N_BP=0000 0010
	main_W_com_data(0x0028,0x0002); // N_FP=0000 0010
	main_W_com_data(0x0029,0x0002); // PI_BP=0000 0010
	main_W_com_data(0x002a,0x0002); // PI_FP=0000 0010
	main_W_com_data(0x002C,0x0002); // I_BP=0000 0010
	main_W_com_data(0x002d,0x0002); // I_FP=0000 0010

	main_W_com_data(0x003a,0x0001); // N_RTN=0000, N_NW=001    0001
	main_W_com_data(0x003b,0x0000); // P_RTN=0000, P_NW=001
	main_W_com_data(0x003c,0x00f0); // I_RTN=1111, I_NW=000
	main_W_com_data(0x003d,0x0000); // DIV=00
	delayms(1);
	main_W_com_data(0x0035,0x0038); // EQS=38h
	main_W_com_data(0x0036,0x0078); // EQP=78h
	main_W_com_data(0x003E,0x0038); // SON=38h
	main_W_com_data(0x0040,0x000F); // GDON=0Fh
	main_W_com_data(0x0041,0x00F0); // GDOFF

	// Power Supply Setting
	main_W_com_data(0x0019,0x0049); // CADJ=0100, CUADJ=100, OSD_EN=1 ,60Hz
	main_W_com_data(0x0093,0x000F); // RADJ=1111, 100%
	delayms(1);
	main_W_com_data(0x0020,0x0040); // BT=0100
	main_W_com_data(0x001D,0x0007); // VC1=111   0007
	main_W_com_data(0x001E,0x0000); // VC3=000
	main_W_com_data(0x001F,0x0004); // VRH=0011

	//VCOM SETTING
	main_W_com_data(0x0044,0x004D); // VCM=101 0000  4D
	main_W_com_data(0x0045,0x000E); // VDV=1 0001   0011
	delayms(1);
	main_W_com_data(0x001C,0x0004); // AP=100
	delayms(2);

	main_W_com_data(0x001B,0x0018); // GASENB=0, PON=0, DK=1, XDK=0, VLCD_TRI=0, STB=0
	delayms(1);
	main_W_com_data(0x001B,0x0010); // GASENB=0, PON=1, DK=0, XDK=0, VLCD_TRI=0, STB=0
	delayms(1);
	main_W_com_data(0x0043,0x0080); //set VCOMG=1
	delayms(2);

	// Display ON Setting
	main_W_com_data(0x0090,0x007F); // SAP=0111 1111
	main_W_com_data(0x0026,0x0004); //GON=0, DTE=0, D=01
	delayms(1);
	main_W_com_data(0x0026,0x0024); //GON=1, DTE=0, D=01
	main_W_com_data(0x0026,0x002C); //GON=1, DTE=0, D=11
	delayms(1);
	main_W_com_data(0x0026,0x003C); //GON=1, DTE=1, D=11

	// INTERNAL REGISTER SETTING
	main_W_com_data(0x0057,0x0002); // TEST_Mode=1: into TEST mode
	main_W_com_data(0x0095,0x0001); // SET DISPLAY CLOCK AND PUMPING CLOCK TO SYNCHRONIZE
	main_W_com_data(0x0057,0x0000); // TEST_Mode=0: exit TEST mode
	//main_W_com_data(0x0021,0x0000);
	main_Write_COM(0x0022);

}


void Pant(unsigned int color)
{
	int i,j;
	address_set(0,0,239,319);

    for(i=0;i<320;i++)
	 {
	  for (j=0;j<240;j++)
	   	{
         main_Write_DATA(color);
	    }

	  }
}

int main(void) {
	Init();
	main_init();
	while(1) {
		Pant(0xf800);
		delayms(1000);
		Pant(0X07E0);
		delayms(1000);
		Pant(0x001f);
		delayms(1000);
    }
//	while(1) __WFI();
	return 0 ;
}
