/*
===============================================================================
 Name        : main.c
 Author      : 
 Version     :
 Copyright   : Copyright (C)
 Description : main definition
===============================================================================
*/

#ifdef __USE_CMSIS
#include "LPC13xx.h"
#endif


#define	IOCON_COMMON_MODE_PULLDOWN	(1<<3)
#define IOCON_COMMON_MODE_PULLUP	(1<<4)

void ledSet(unsigned val) {
	if(val)	LPC_GPIO0->DATA |= 1<<7;
	else	LPC_GPIO0->DATA &= ~(1<<7);
}

/// Устанавливает признак ошибки и блокирует продолжение выполнения кода
void fatalError(int code)
{
	(void) code; // отключаем предупреждение компилятора
	ledSet(1);
	while (1);
}


// --- Средства работы со временем - Системный таймер ---

static volatile uint32_t msTicks = 0;		// counts 1ms timeTicks

void SysTick_Handler(void)
{
	msTicks++;		// инкремент счётчика времени
}

void delay_ms(uint32_t ms)
{
	uint32_t startTicks;
	startTicks = msTicks;
	while((msTicks - startTicks) < ms);	// Ждем завершения периода
}


// --- Средства работы с дисплеем ---

void SPI_init() {	// Раздел 13.2 UM10375
    // Reset SSP (пункт 4)
	LPC_SYSCON->PRESETCTRL &= ~(1<<0);	// "маска" сброса SSP
	LPC_SYSCON->PRESETCTRL |= (1<<0);	// 1 в бит RST_SSP_0

    // Enable AHB clock to the SSP domain. (пункт 2)
    LPC_SYSCON->SYSAHBCLKCTRL |= (1<<11);

    // Divide by 1 (SSPCLKDIV also enables to SSP CLK) (пункт 3)
    LPC_SSP->CPSR = 0;	// отключим тактирование (а то мало ли)

    // Настройка портов ввода-вывода на SSP (пункт 1)
    // Set P0.8 to SSP MISO - мы пока не используем
    //IOCON_PIO0_8 &= ~IOCON_PIO0_8_FUNC_MASK;
    //IOCON_PIO0_8 |= IOCON_PIO0_8_FUNC_MISO0;
    // Set P0.9 to SSP MOSI
    LPC_IOCON->PIO0_9	&= ~(7<<0);
    LPC_IOCON->PIO0_9	|= (1<<0);	// использовать как вывод MOSI
    LPC_IOCON->PIO0_9	|= IOCON_COMMON_MODE_PULLUP;
    // Set 2.11 to SSP SCK (0.6 and 0.10 can also be used)
    LPC_IOCON->SCKLOC	= 1;	// SCK на вывод 2.11
    LPC_IOCON->PIO2_11	&= ~(7<<0);	// сброс текущей функции порта ввода-вывода
    LPC_IOCON->PIO2_11	|= (1<<0);	// использовать как вывод SCK
    LPC_IOCON->PIO2_11	|= IOCON_COMMON_MODE_PULLUP;
    // Set P0.2/SSEL to GPIO output and high
    LPC_IOCON->PIO0_2	&= ~(7<<0);	// сброс текущей функции порта ввода-вывода
    LPC_IOCON->PIO0_2	|= (1<<0);	// использовать как вывод SSEL	(можно обычным GPIO как 0)
    LPC_IOCON->PIO0_2	|= IOCON_COMMON_MODE_PULLUP;
    LPC_GPIO0->DIR	|= 1<<2;
    LPC_GPIO0->DATA	|= 1<<2;

    // If SSP0CLKDIV = DIV1 -- (PCLK / (CPSDVSR X [SCR+1])) = (72,000,000 / (2 x [8 + 1])) = 4.0 MHz
    LPC_SSP->CR0	= ( (8<<0)	// Размер данных 1000 - 9 бит
					  | (0<<4)	// Формат фрейма 00 - SPI
					  | (0<<6)	// Полярность 0 - низкий уровень между фреймами
					  | (0<<7)	// Фаза 0 - по нарастанию
					  | (8<<8)	// Делитель частоты шины на бит
					  //| (3<<8)	// Делитель частоты шины на бит
					  ) ;

    // Clock prescale register must be even and at least 2 in master mode
    LPC_SSP->CPSR = 2;	// пердделитель 2-254 (кратно 2)

    // Clear the Rx FIFO (игнорируем)
    //uint8_t i, Dummy=Dummy;
    //for ( i = 0; i < SSP_FIFOSIZE; i++ ) { Dummy = SSP_SSP0DR; }

    // Enable device and set it to master mode, no loopback (разрешаем работу)
    LPC_SSP->CR1	= ( (0<<0)	// 0 - Loop Back Mode Normal
					  | (1<<1)	// Разрешение работы 1 - разрешено
					  | (0<<2)	// Режим ведущий-ведомый 0 - мастер
					  );
}

void SPI_send(uint16_t value) {
	while ((LPC_SSP->SR & ((1<<1) | (1<<4))) != (1<<1));	// если буффер передачи не переполнен и устройство не занято
	//LPC_GPIO2->DATA	&= ~(1<<9);	// ncs = 0
	LPC_SSP->DR = value;
	//uint16_t Dummy = Dummy;
	//while ( (SSP_SSP0SR & (SSP_SSP0SR_BSY_BUSY|SSP_SSP0SR_RNE_NOTEMPTY)) != SSP_SSP0SR_RNE_NOTEMPTY );
	//Dummy = SSP_SSP0DR;
	//while ((LPC_SSP->SR & ((1<<1) | (1<<4))) != (1<<1));	// если буффер передачи не переполнен и устройство не занято
	//LPC_GPIO2->DATA	|= 1<<9;	// ncs = 1
}

void LCD_reset(void) {
	// Настройка для вывода Reset дисплея
	LPC_IOCON->PIO0_8	&= ~(7<<0);	// сброс текущей функции порта ввода-вывода
	LPC_IOCON->PIO0_8	|= IOCON_COMMON_MODE_PULLUP;
	LPC_GPIO0->DIR	|= 1<<8;
	LPC_GPIO0->DATA	|= 1<<8;
    // Настройка для вывода Select
    LPC_IOCON->PIO0_2	&= ~(7<<0);	// Временно отключаем спецфункцию вывода выбора SPI
	delay_ms(100);
	// Сброс дисплея
	LPC_GPIO0->DATA	&= ~(1<<2);	// ncs = 0
    LPC_GPIO0->DATA	&= ~(1<<8);	// nrst = 0
    delay_ms(100);
    LPC_GPIO0->DATA	|= 1<<8;	// nrst = 1
	LPC_GPIO0->DATA	|= 1<<2;	// ncs = 1
	delay_ms(100);
	// Возврат спецфункции
	LPC_IOCON->PIO0_2	|= (1<<0);	// использовать как вывод SSEL
}

uint8_t _mono[96*9];	// Frame buffer for mono screens

void BlitMono()
{
	SPI_send(0xB0);
	SPI_send(0x10);
	SPI_send(0x00);
	int i;
	for (i = 0; i < sizeof(_mono); i++)
		SPI_send(0x100 | _mono[i]);
}

void LCD_init()
{
	SPI_init();
//	SPI_send(0x11);	// SLEEPOUT
	LCD_reset();
	SPI_send(0xE2);
	delay_ms(10);
	SPI_send(0xAF);
	SPI_send(0xA4);
	SPI_send(0x2F);
	SPI_send(0xB0);	// Page
	SPI_send(0x10);
	SPI_send(0x00);	// Col low
}

void grid() {
	int i, j, x, y;
	SPI_send(0xB0);
	SPI_send(0x10);
	SPI_send(0x00);
	for(i = 0; i < 9; i++) {
		y = (i>>3) | (i&0x04) | ((i<<3)&0x10)  | ((i<<6)&0x40) ;
		y = ~y & 0x7F;
		for(j = 0; j < 12; j++) {
			x = (j>>3) | (j&0x04) | ((j<<3)&0x10)  | ((j<<6)&0x40) ;
			x = ~x & 0x7F;
			SPI_send(0x100|0x7F);
			SPI_send(0x100|x);
			SPI_send(0x100|x);
			SPI_send(0x100|0x7F);
			SPI_send(0x100|y);
			SPI_send(0x100|y);
			SPI_send(0x100|0x7F);
			SPI_send(0x100|0x00);
		}

	}

}
void test(int i) {
	int j;
	SPI_send(0xB0);
	SPI_send(0x10);
	//SPI_send(i&0x1F); //Сдвиг вправо
	for(j = 0; j < 8; j++)
		SPI_send(0x100);	// Black square
}

#include "font5x8.h"
void drawchar(char c) {
	int i;
	unsigned char *ptr = &font[5*(unsigned int)c];
	for(i = 0; i < 5; i++) {
		SPI_send(0x100|~ptr[i]);
	}
	SPI_send(0x1FF); // пробел
}

void drawstr(const char *c) {
	while(*c) drawchar(*c++);
}

void setpos(uint8_t x, uint8_t y) {
	if(y > 9) y = 0;
	if(x > 96) x = 0;
	SPI_send(0xB0|(y));		// Номер строки
	SPI_send(0x10|(x>>4));	// Старшие 4 байта номера столбца
	SPI_send(0x0F&(x));		// Младшие 4 байта номера столбца
}

void init() {
	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<6);
  	LPC_IOCON->PIO0_7 = IOCON_COMMON_MODE_PULLDOWN;		// Pull Dn
  	LPC_GPIO0->DATA = 0;
  	LPC_GPIO0->DIR |= 1<<7;			// Вывод 0.7 на выход
  	LPC_IOCON->PIO3_0 = IOCON_COMMON_MODE_PULLUP;		// Pull Up
  	LPC_GPIO3->DIR &= ~(1<<0);		// Вывод 3.0 на вход
	if (SysTick_Config(SystemCoreClock / 1000)) {	// настройка таймера на период 1мс
		//while (1);
		fatalError(0);                      // Ошибка настройки
	}
	//NVIC_SetPriority(SysTick_IRQn, 1);		// задаем почти максимальный приоритет
	if ( !(SysTick->CTRL & SysTick_CTRL_CLKSOURCE_Msk) ) {
		LPC_SYSCON->SYSTICKCLKDIV = 0x08;	// из 16.6.1 замечание к внешнему таймеру (по примеру)
	}

	LCD_init();
	int j;for(j = 0; j < sizeof(_mono); j++)_mono[j] = 0xFF;
	BlitMono();
}

int main(void) {
	init();
	int i = 0, j;
	int mode = 0;
	int data = 0, data2 = 0, sendb0 = 1, send10 = 1, senddata = 0, send0 = 1, drawgrid = 1, drawsquare = 1;
	while(1) {
		//grid();
		//test(i);
		switch(mode) {
		case 1:
			SPI_send(0xB0);
			SPI_send(0x10);
			SPI_send(0x00);
			for(j = 0; j < sizeof(_mono); j++)
				SPI_send(0x100|((j&7)==7||(j/8)==(i%108) ? 0x00 : 0x7F));	// White Screen with grid
			delay_ms(100);
			i++;
			if(i > 108*3) {
				i = 0;
				mode = 0;
			}
			break;

		case 2: // debug only
			if(drawgrid) grid();
			if(sendb0)	 SPI_send(0xB0);
			if(senddata) SPI_send(data);
			if(send10)	 SPI_send(0x10);
			if(send0)	 SPI_send(0x00);
			if(drawsquare) for(j = 0; j < 8; j++) SPI_send(0x100);
			break;

		case 3:
			SPI_send(0xB0);
			SPI_send(0x10);
			SPI_send(0x00);
			for(j = 0; j < 128; j++) drawchar(j);
			delay_ms(5000);
			mode = 8;
			break;

		case 4:	// debug only
			setpos(data, data2);
			drawstr("Hello World!");
			break;

		case 5:
			for(j = 0; j < sizeof(_mono); j++)_mono[j] = 0xFF;	// blue
			BlitMono();
			delay_ms(1000);
			mode = 3;
			break;

		case 6:
			for(j = 0; j < sizeof(_mono); j++)_mono[j] = 0x00;	// black
			BlitMono();
			delay_ms(1000);
			mode = 7;
			break;

		case 7:
			for(j = 0; j < sizeof(_mono); j++)_mono[j] = j;	//
			BlitMono();
			delay_ms(5000);
			mode = 1;
			break;

		case 8:
			SPI_send(0xB0);
			SPI_send(0x10);
			SPI_send(0x00);
			for(j = 128; j < 256; j++) drawchar(j);
			delay_ms(5000);
			mode = 6;
			break;

		default:
			setpos(13, 1);
			drawstr("Hello World!");
			setpos(21, 3);
			drawstr("by Angel5a");
			setpos(4, 5);
			drawstr("angel5a@mail.ru");
			setpos(16, 7);
			drawstr("for we at EE");
			delay_ms(5000);
			mode = 5;
			break;

		}
	}
	return 0 ;
}
