﻿//------------------------------------------------------------------------------
// Файл		: verdana10.c
// Описание	: Реализация шрифта Verdana 10pt только латинница.
//------------------------------------------------------------------------------

#include <stdint.h>
#include "font.h"

// Character bitmaps for Verdana 10pt
const uint8_t verdana10ptCharBitmaps[] =
{
	/* @0 ' ' (2 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @13 '!' (1 pixels wide) */
	0x00, /*          */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @26 '"' (3 pixels wide) */
	0xA0, /* # #      */
	0xA0, /* # #      */
	0xA0, /* # #      */
	0xA0, /* # #      */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @39 '#' (8 pixels wide) */
	0x00, /*          */
	0x12, /*    #  #  */
	0x12, /*    #  #  */
	0x7F, /*  ####### */
	0x24, /*   #  #   */
	0x24, /*   #  #   */
	0xFE, /* #######  */
	0x48, /*  #  #    */
	0x48, /*  #  #    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @52 '$' (6 pixels wide) */
	0x20, /*   #      */
	0x20, /*   #      */
	0x7C, /*  #####   */
	0xA0, /* # #      */
	0xA0, /* # #      */
	0x60, /*  ##      */
	0x38, /*   ###    */
	0x24, /*   #  #   */
	0x24, /*   #  #   */
	0xF8, /* #####    */
	0x20, /*   #      */
	0x20, /*   #      */
	0x00, /*          */

	/* @65 '%' (11 pixels wide) */
	0x00, 0x00, /*                  */
	0x70, 0x80, /*  ###    #        */
	0x89, 0x00, /* #   #  #         */
	0x8A, 0x00, /* #   # #          */
	0x8A, 0x00, /* #   # #          */
	0x75, 0xC0, /*  ### # ###       */
	0x0A, 0x20, /*     # #   #      */
	0x0A, 0x20, /*     # #   #      */
	0x12, 0x20, /*    #  #   #      */
	0x21, 0xC0, /*   #    ###       */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */

	/* @91 '&' (8 pixels wide) */
	0x00, /*          */
	0x70, /*  ###     */
	0x88, /* #   #    */
	0x88, /* #   #    */
	0x88, /* #   #    */
	0x71, /*  ###   # */
	0x8A, /* #   # #  */
	0x84, /* #    #   */
	0x8C, /* #   ##   */
	0x73, /*  ###  ## */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @104 ''' (1 pixels wide) */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @117 '(' (4 pixels wide) */
	0x10, /*    #     */
	0x20, /*   #      */
	0x40, /*  #       */
	0x40, /*  #       */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x40, /*  #       */
	0x40, /*  #       */
	0x20, /*   #      */
	0x10, /*    #     */

	/* @130 ')' (4 pixels wide) */
	0x80, /* #        */
	0x40, /*  #       */
	0x20, /*   #      */
	0x20, /*   #      */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x20, /*   #      */
	0x20, /*   #      */
	0x40, /*  #       */
	0x80, /* #        */

	/* @143 '*' (5 pixels wide) */
	0x20, /*   #      */
	0xA8, /* # # #    */
	0x70, /*  ###     */
	0xA8, /* # # #    */
	0x20, /*   #      */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @156 '+' (7 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0xFE, /* #######  */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @169 ',' (2 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x80, /* #        */
	0x00, /*          */

	/* @182 '-' (5 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0xF8, /* #####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @195 '.' (1 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @208 '/' (6 pixels wide) */
	0x04, /*      #   */
	0x04, /*      #   */
	0x08, /*     #    */
	0x08, /*     #    */
	0x10, /*    #     */
	0x10, /*    #     */
	0x20, /*   #      */
	0x20, /*   #      */
	0x40, /*  #       */
	0x40, /*  #       */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */

	/* @221 '0' (6 pixels wide) */
	0x00, /*          */
	0x78, /*  ####    */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x78, /*  ####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @234 '1' (5 pixels wide) */
	0x00, /*          */
	0x20, /*   #      */
	0xE0, /* ###      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0xF8, /* #####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @247 '2' (6 pixels wide) */
	0x00, /*          */
	0x78, /*  ####    */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x04, /*      #   */
	0x08, /*     #    */
	0x30, /*   ##     */
	0x40, /*  #       */
	0x80, /* #        */
	0xFC, /* ######   */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @260 '3' (6 pixels wide) */
	0x00, /*          */
	0x78, /*  ####    */
	0x84, /* #    #   */
	0x04, /*      #   */
	0x04, /*      #   */
	0x38, /*   ###    */
	0x04, /*      #   */
	0x04, /*      #   */
	0x84, /* #    #   */
	0x78, /*  ####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @273 '4' (7 pixels wide) */
	0x00, /*          */
	0x08, /*     #    */
	0x18, /*    ##    */
	0x28, /*   # #    */
	0x48, /*  #  #    */
	0x88, /* #   #    */
	0xFE, /* #######  */
	0x08, /*     #    */
	0x08, /*     #    */
	0x08, /*     #    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @286 '5' (6 pixels wide) */
	0x00, /*          */
	0x7C, /*  #####   */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x78, /*  ####    */
	0x04, /*      #   */
	0x04, /*      #   */
	0x84, /* #    #   */
	0x78, /*  ####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @299 '6' (6 pixels wide) */
	0x00, /*          */
	0x38, /*   ###    */
	0x40, /*  #       */
	0x80, /* #        */
	0xF8, /* #####    */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x78, /*  ####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @312 '7' (6 pixels wide) */
	0x00, /*          */
	0xFC, /* ######   */
	0x04, /*      #   */
	0x08, /*     #    */
	0x08, /*     #    */
	0x10, /*    #     */
	0x10, /*    #     */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @325 '8' (6 pixels wide) */
	0x00, /*          */
	0x78, /*  ####    */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x78, /*  ####    */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x78, /*  ####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @338 '9' (6 pixels wide) */
	0x00, /*          */
	0x78, /*  ####    */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x7C, /*  #####   */
	0x04, /*      #   */
	0x08, /*     #    */
	0x70, /*  ###     */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @351 ':' (1 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @364 ';' (2 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x40, /*  #       */
	0x40, /*  #       */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x80, /* #        */
	0x00, /*          */

	/* @377 '<' (7 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x06, /*      ##  */
	0x18, /*    ##    */
	0x60, /*  ##      */
	0x80, /* #        */
	0x60, /*  ##      */
	0x18, /*    ##    */
	0x06, /*      ##  */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @390 '=' (7 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0xFE, /* #######  */
	0x00, /*          */
	0x00, /*          */
	0xFE, /* #######  */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @403 '>' (7 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0xC0, /* ##       */
	0x30, /*   ##     */
	0x0C, /*     ##   */
	0x02, /*       #  */
	0x0C, /*     ##   */
	0x30, /*   ##     */
	0xC0, /* ##       */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @416 '?' (5 pixels wide) */
	0x00, /*          */
	0x70, /*  ###     */
	0x88, /* #   #    */
	0x08, /*     #    */
	0x10, /*    #     */
	0x20, /*   #      */
	0x20, /*   #      */
	0x00, /*          */
	0x20, /*   #      */
	0x20, /*   #      */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @429 '@' (11 pixels wide) */
	0x00, 0x00, /*                  */
	0x1F, 0x00, /*    #####         */
	0x20, 0x80, /*   #     #        */
	0x4F, 0x40, /*  #  #### #       */
	0x91, 0x20, /* #  #   #  #      */
	0x91, 0x20, /* #  #   #  #      */
	0x91, 0x20, /* #  #   #  #      */
	0x91, 0x20, /* #  #   #  #      */
	0x91, 0x20, /* #  #   #  #      */
	0x4F, 0xC0, /*  #  ######       */
	0x20, 0x00, /*   #              */
	0x1F, 0x00, /*    #####         */
	0x00, 0x00, /*                  */

	/* @455 'A' (7 pixels wide) */
	0x00, /*          */
	0x10, /*    #     */
	0x10, /*    #     */
	0x28, /*   # #    */
	0x28, /*   # #    */
	0x44, /*  #   #   */
	0x44, /*  #   #   */
	0x7C, /*  #####   */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @468 'B' (6 pixels wide) */
	0x00, /*          */
	0xF0, /* ####     */
	0x88, /* #   #    */
	0x88, /* #   #    */
	0x88, /* #   #    */
	0xF8, /* #####    */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0xF8, /* #####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @481 'C' (7 pixels wide) */
	0x00, /*          */
	0x3C, /*   ####   */
	0x42, /*  #    #  */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x42, /*  #    #  */
	0x3C, /*   ####   */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @494 'D' (7 pixels wide) */
	0x00, /*          */
	0xF8, /* #####    */
	0x84, /* #    #   */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x84, /* #    #   */
	0xF8, /* #####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @507 'E' (6 pixels wide) */
	0x00, /*          */
	0xFC, /* ######   */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0xFC, /* ######   */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0xFC, /* ######   */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @520 'F' (6 pixels wide) */
	0x00, /*          */
	0xFC, /* ######   */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0xF8, /* #####    */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @533 'G' (7 pixels wide) */
	0x00, /*          */
	0x3C, /*   ####   */
	0x42, /*  #    #  */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x8E, /* #   ###  */
	0x82, /* #     #  */
	0x42, /*  #    #  */
	0x3E, /*   #####  */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @546 'H' (7 pixels wide) */
	0x00, /*          */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0xFE, /* #######  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @559 'I' (3 pixels wide) */
	0x00, /*          */
	0xE0, /* ###      */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0xE0, /* ###      */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @572 'J' (5 pixels wide) */
	0x00, /*          */
	0x38, /*   ###    */
	0x08, /*     #    */
	0x08, /*     #    */
	0x08, /*     #    */
	0x08, /*     #    */
	0x08, /*     #    */
	0x08, /*     #    */
	0x08, /*     #    */
	0xF0, /* ####     */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @585 'K' (6 pixels wide) */
	0x00, /*          */
	0x84, /* #    #   */
	0x88, /* #   #    */
	0x90, /* #  #     */
	0xA0, /* # #      */
	0xC0, /* ##       */
	0xA0, /* # #      */
	0x90, /* #  #     */
	0x88, /* #   #    */
	0x84, /* #    #   */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @598 'L' (6 pixels wide) */
	0x00, /*          */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0xFC, /* ######   */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @611 'M' (9 pixels wide) */
	0x00, 0x00, /*                  */
	0xC1, 0x80, /* ##     ##        */
	0xC1, 0x80, /* ##     ##        */
	0xA2, 0x80, /* # #   # #        */
	0xA2, 0x80, /* # #   # #        */
	0x94, 0x80, /* #  # #  #        */
	0x94, 0x80, /* #  # #  #        */
	0x88, 0x80, /* #   #   #        */
	0x88, 0x80, /* #   #   #        */
	0x80, 0x80, /* #       #        */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */

	/* @637 'N' (7 pixels wide) */
	0x00, /*          */
	0xC2, /* ##    #  */
	0xC2, /* ##    #  */
	0xA2, /* # #   #  */
	0xA2, /* # #   #  */
	0x92, /* #  #  #  */
	0x8A, /* #   # #  */
	0x8A, /* #   # #  */
	0x86, /* #    ##  */
	0x86, /* #    ##  */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @650 'O' (8 pixels wide) */
	0x00, /*          */
	0x3C, /*   ####   */
	0x42, /*  #    #  */
	0x81, /* #      # */
	0x81, /* #      # */
	0x81, /* #      # */
	0x81, /* #      # */
	0x81, /* #      # */
	0x42, /*  #    #  */
	0x3C, /*   ####   */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @663 'P' (6 pixels wide) */
	0x00, /*          */
	0xF8, /* #####    */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0xF8, /* #####    */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @676 'Q' (8 pixels wide) */
	0x00, /*          */
	0x3C, /*   ####   */
	0x42, /*  #    #  */
	0x81, /* #      # */
	0x81, /* #      # */
	0x81, /* #      # */
	0x81, /* #      # */
	0x81, /* #      # */
	0x42, /*  #    #  */
	0x3C, /*   ####   */
	0x04, /*      #   */
	0x03, /*       ## */
	0x00, /*          */

	/* @689 'R' (7 pixels wide) */
	0x00, /*          */
	0xF8, /* #####    */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x88, /* #   #    */
	0xF0, /* ####     */
	0x88, /* #   #    */
	0x84, /* #    #   */
	0x82, /* #     #  */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @702 'S' (7 pixels wide) */
	0x00, /*          */
	0x7C, /*  #####   */
	0x82, /* #     #  */
	0x80, /* #        */
	0x80, /* #        */
	0x7C, /*  #####   */
	0x02, /*       #  */
	0x02, /*       #  */
	0x82, /* #     #  */
	0x7C, /*  #####   */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @715 'T' (7 pixels wide) */
	0x00, /*          */
	0xFE, /* #######  */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @728 'U' (7 pixels wide) */
	0x00, /*          */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x44, /*  #   #   */
	0x38, /*   ###    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @741 'V' (7 pixels wide) */
	0x00, /*          */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x44, /*  #   #   */
	0x44, /*  #   #   */
	0x28, /*   # #    */
	0x28, /*   # #    */
	0x10, /*    #     */
	0x10, /*    #     */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @754 'W' (11 pixels wide) */
	0x00, 0x00, /*                  */
	0x84, 0x20, /* #    #    #      */
	0x84, 0x20, /* #    #    #      */
	0x8A, 0x20, /* #   # #   #      */
	0x8A, 0x20, /* #   # #   #      */
	0x4A, 0x40, /*  #  # #  #       */
	0x51, 0x40, /*  # #   # #       */
	0x51, 0x40, /*  # #   # #       */
	0x20, 0x80, /*   #     #        */
	0x20, 0x80, /*   #     #        */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */

	/* @780 'X' (7 pixels wide) */
	0x00, /*          */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x44, /*  #   #   */
	0x28, /*   # #    */
	0x10, /*    #     */
	0x28, /*   # #    */
	0x44, /*  #   #   */
	0x82, /* #     #  */
	0x82, /* #     #  */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @793 'Y' (7 pixels wide) */
	0x00, /*          */
	0x82, /* #     #  */
	0x44, /*  #   #   */
	0x44, /*  #   #   */
	0x28, /*   # #    */
	0x28, /*   # #    */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @806 'Z' (7 pixels wide) */
	0x00, /*          */
	0xFE, /* #######  */
	0x02, /*       #  */
	0x04, /*      #   */
	0x08, /*     #    */
	0x10, /*    #     */
	0x20, /*   #      */
	0x40, /*  #       */
	0x80, /* #        */
	0xFE, /* #######  */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @819 '[' (3 pixels wide) */
	0xE0, /* ###      */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0xE0, /* ###      */
	0x00, /*          */

	/* @832 '\' (6 pixels wide) */
	0x80, /* #        */
	0x80, /* #        */
	0x40, /*  #       */
	0x40, /*  #       */
	0x20, /*   #      */
	0x20, /*   #      */
	0x10, /*    #     */
	0x10, /*    #     */
	0x08, /*     #    */
	0x08, /*     #    */
	0x04, /*      #   */
	0x04, /*      #   */
	0x00, /*          */

	/* @845 ']' (3 pixels wide) */
	0xE0, /* ###      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0xE0, /* ###      */
	0x00, /*          */

	/* @858 '^' (9 pixels wide) */
	0x00, 0x00, /*                  */
	0x08, 0x00, /*     #            */
	0x14, 0x00, /*    # #           */
	0x22, 0x00, /*   #   #          */
	0x41, 0x00, /*  #     #         */
	0x80, 0x80, /* #       #        */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */

	/* @884 '_' (8 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0xFF, /* ######## */
	0x00, /*          */

	/* @897 '`' (2 pixels wide) */
	0x80, /* #        */
	0x40, /*  #       */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @910 'a' (6 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x78, /*  ####    */
	0x04, /*      #   */
	0x04, /*      #   */
	0x7C, /*  #####   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x7C, /*  #####   */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @923 'b' (6 pixels wide) */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0xB8, /* # ###    */
	0xC4, /* ##   #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0xF8, /* #####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @936 'c' (6 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x78, /*  ####    */
	0x84, /* #    #   */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x84, /* #    #   */
	0x78, /*  ####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @949 'd' (6 pixels wide) */
	0x04, /*      #   */
	0x04, /*      #   */
	0x04, /*      #   */
	0x7C, /*  #####   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x8C, /* #   ##   */
	0x74, /*  ### #   */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @962 'e' (6 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x78, /*  ####    */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0xFC, /* ######   */
	0x80, /* #        */
	0x84, /* #    #   */
	0x78, /*  ####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @975 'f' (5 pixels wide) */
	0x38, /*   ###    */
	0x40, /*  #       */
	0x40, /*  #       */
	0xF0, /* ####     */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @988 'g' (6 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x7C, /*  #####   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x8C, /* #   ##   */
	0x74, /*  ### #   */
	0x04, /*      #   */
	0x04, /*      #   */
	0x78, /*  ####    */

	/* @1001 'h' (6 pixels wide) */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0xB8, /* # ###    */
	0xC4, /* ##   #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1014 'i' (1 pixels wide) */
	0x80, /* #        */
	0x00, /*          */
	0x00, /*          */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1027 'j' (4 pixels wide) */
	0x10, /*    #     */
	0x00, /*          */
	0x00, /*          */
	0x30, /*   ##     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0x10, /*    #     */
	0xE0, /* ###      */

	/* @1040 'k' (5 pixels wide) */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x88, /* #   #    */
	0x90, /* #  #     */
	0xA0, /* # #      */
	0xC0, /* ##       */
	0xA0, /* # #      */
	0x90, /* #  #     */
	0x88, /* #   #    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1053 'l' (1 pixels wide) */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1066 'm' (9 pixels wide) */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0xB3, 0x00, /* # ##  ##         */
	0xCC, 0x80, /* ##  ##  #        */
	0x88, 0x80, /* #   #   #        */
	0x88, 0x80, /* #   #   #        */
	0x88, 0x80, /* #   #   #        */
	0x88, 0x80, /* #   #   #        */
	0x88, 0x80, /* #   #   #        */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */

	/* @1092 'n' (6 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0xB8, /* # ###    */
	0xC4, /* ##   #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1105 'o' (6 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x78, /*  ####    */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x78, /*  ####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1118 'p' (6 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0xB8, /* # ###    */
	0xC4, /* ##   #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0xF8, /* #####    */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */

	/* @1131 'q' (6 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x7C, /*  #####   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x8C, /* #   ##   */
	0x74, /*  ### #   */
	0x04, /*      #   */
	0x04, /*      #   */
	0x04, /*      #   */

	/* @1144 'r' (4 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0xB0, /* # ##     */
	0xC0, /* ##       */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1157 's' (5 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x78, /*  ####    */
	0x80, /* #        */
	0x80, /* #        */
	0x70, /*  ###     */
	0x08, /*     #    */
	0x08, /*     #    */
	0xF0, /* ####     */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1170 't' (4 pixels wide) */
	0x00, /*          */
	0x40, /*  #       */
	0x40, /*  #       */
	0xF0, /* ####     */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x40, /*  #       */
	0x30, /*   ##     */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1183 'u' (6 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x8C, /* #   ##   */
	0x74, /*  ### #   */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1196 'v' (6 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x48, /*  #  #    */
	0x48, /*  #  #    */
	0x48, /*  #  #    */
	0x30, /*   ##     */
	0x30, /*   ##     */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1209 'w' (9 pixels wide) */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x88, 0x80, /* #   #   #        */
	0x88, 0x80, /* #   #   #        */
	0x55, 0x00, /*  # # # #         */
	0x55, 0x00, /*  # # # #         */
	0x55, 0x00, /*  # # # #         */
	0x22, 0x00, /*   #   #          */
	0x22, 0x00, /*   #   #          */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */
	0x00, 0x00, /*                  */

	/* @1235 'x' (5 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x88, /* #   #    */
	0x88, /* #   #    */
	0x50, /*  # #     */
	0x20, /*   #      */
	0x50, /*  # #     */
	0x88, /* #   #    */
	0x88, /* #   #    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1248 'y' (6 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x84, /* #    #   */
	0x84, /* #    #   */
	0x48, /*  #  #    */
	0x48, /*  #  #    */
	0x48, /*  #  #    */
	0x30, /*   ##     */
	0x30, /*   ##     */
	0x20, /*   #      */
	0x20, /*   #      */
	0x40, /*  #       */

	/* @1261 'z' (5 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0xF8, /* #####    */
	0x08, /*     #    */
	0x10, /*    #     */
	0x20, /*   #      */
	0x40, /*  #       */
	0x80, /* #        */
	0xF8, /* #####    */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */

	/* @1274 '{' (5 pixels wide) */
	0x18, /*    ##    */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0xC0, /* ##       */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x18, /*    ##    */
	0x00, /*          */

	/* @1287 '|' (1 pixels wide) */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x80, /* #        */
	0x00, /*          */

	/* @1300 '}' (5 pixels wide) */
	0xC0, /* ##       */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x18, /*    ##    */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0x20, /*   #      */
	0xC0, /* ##       */
	0x00, /*          */

	/* @1313 '~' (8 pixels wide) */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x61, /*  ##    # */
	0x99, /* #  ##  # */
	0x86, /* #    ##  */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
	0x00, /*          */
};

/* Character descriptors for Verdana 10pt */
/* { [Char width in bits], [Offset into verdana10ptCharBitmaps in bytes] } */
const FONT_CHAR_INFO verdana10ptCharDescriptors[] =
{
	{2, 0}, 		/*   */
	{1, 13}, 		/* ! */
	{3, 26}, 		/* " */
	{8, 39}, 		/* # */
	{6, 52}, 		/* $ */
	{11, 65}, 		/* % */
	{8, 91}, 		/* & */
	{1, 104}, 		/* ' */
	{4, 117}, 		/* ( */
	{4, 130}, 		/* ) */
	{5, 143}, 		/* * */
	{7, 156}, 		/* + */
	{2, 169}, 		/* , */
	{5, 182}, 		/* - */
	{1, 195}, 		/* . */
	{6, 208}, 		/* / */
	{6, 221}, 		/* 0 */
	{5, 234}, 		/* 1 */
	{6, 247}, 		/* 2 */
	{6, 260}, 		/* 3 */
	{7, 273}, 		/* 4 */
	{6, 286}, 		/* 5 */
	{6, 299}, 		/* 6 */
	{6, 312}, 		/* 7 */
	{6, 325}, 		/* 8 */
	{6, 338}, 		/* 9 */
	{1, 351}, 		/* : */
	{2, 364}, 		/* ; */
	{7, 377}, 		/* < */
	{7, 390}, 		/* = */
	{7, 403}, 		/* > */
	{5, 416}, 		/* ? */
	{11, 429}, 		/* @ */
	{7, 455}, 		/* A */
	{6, 468}, 		/* B */
	{7, 481}, 		/* C */
	{7, 494}, 		/* D */
	{6, 507}, 		/* E */
	{6, 520}, 		/* F */
	{7, 533}, 		/* G */
	{7, 546}, 		/* H */
	{3, 559}, 		/* I */
	{5, 572}, 		/* J */
	{6, 585}, 		/* K */
	{6, 598}, 		/* L */
	{9, 611}, 		/* M */
	{7, 637}, 		/* N */
	{8, 650}, 		/* O */
	{6, 663}, 		/* P */
	{8, 676}, 		/* Q */
	{7, 689}, 		/* R */
	{7, 702}, 		/* S */
	{7, 715}, 		/* T */
	{7, 728}, 		/* U */
	{7, 741}, 		/* V */
	{11, 754}, 		/* W */
	{7, 780}, 		/* X */
	{7, 793}, 		/* Y */
	{7, 806}, 		/* Z */
	{3, 819}, 		/* [ */
	{6, 832}, 		/* \ */
	{3, 845}, 		/* ] */
	{9, 858}, 		/* ^ */
	{8, 884}, 		/* _ */
	{2, 897}, 		/* ` */
	{6, 910}, 		/* a */
	{6, 923}, 		/* b */
	{6, 936}, 		/* c */
	{6, 949}, 		/* d */
	{6, 962}, 		/* e */
	{5, 975}, 		/* f */
	{6, 988}, 		/* g */
	{6, 1001}, 		/* h */
	{1, 1014}, 		/* i */
	{4, 1027}, 		/* j */
	{5, 1040}, 		/* k */
	{1, 1053}, 		/* l */
	{9, 1066}, 		/* m */
	{6, 1092}, 		/* n */
	{6, 1105}, 		/* o */
	{6, 1118}, 		/* p */
	{6, 1131}, 		/* q */
	{4, 1144}, 		/* r */
	{5, 1157}, 		/* s */
	{4, 1170}, 		/* t */
	{6, 1183}, 		/* u */
	{6, 1196}, 		/* v */
	{9, 1209}, 		/* w */
	{5, 1235}, 		/* x */
	{6, 1248}, 		/* y */
	{5, 1261}, 		/* z */
	{5, 1274}, 		/* { */
	{1, 1287}, 		/* | */
	{5, 1300}, 		/* } */
	{8, 1313}, 		/* ~ */
};

// Font information for Verdana 10pt
const FONT_INFO verdana10ptFontInfo =
{
	13,	// Character height
	' ',	// The first character available
	128,	// The last character available
	0,	// Character flags
	verdana10ptCharDescriptors, // Character decriptor array
	verdana10ptCharBitmaps, // Character bitmap array
};

