//  UART  stm8s103f3
#include "uart.h"
#include "iostm8s103f3.h"

// --- Configuration ---

#define UART_TIME_DEBUG

// --- Implimentation ---

void UART_init()
{
  //         
  // Table 54 RM0016 contain precalculated UART deviders
  // DIV = 0x008B -> BRR1=0x08, BRR2 = 0x0B // 115200 at 16MHz
  // DIV = 0x0693 -> BRR1=0x69, BRR2 = 0x03 //   9600 at 16MHz
  UART1_CR1_bit.M     = 0;  // 8 bit dataframe
  UART1_CR1_bit.PCEN  = 0;  //  no paryty in frame (all frame bits are data)
  UART1_CR3_bit.STOP  = 0;  // 1 stop bit
  UART1_BRR2  = 0x0B;       // Note: BRR2 set before BRR1
  UART1_BRR1  = 0x08;       // 115200 kbps at 16 MHz
  //UART1_BRR2  = 0x03;       // Note: BRR2 set before BRR1
  //UART1_BRR1  = 0x69;       // 9600 kbps at 16 MHz
  UART1_CR2_bit.TEN   = 1;  // Enable transmitter
  UART1_CR2_bit.REN   = 1;  // Enable reciver

  UART1_CR2_bit.RIEN  = 1;  // Enable recive interrupt

#ifdef UART_TIME_DEBUG
  PD_ODR_bit.ODR2 = 0;
  PD_DDR_bit.DDR2 = 1; // BUSY_UART
  PD_CR1_bit.C12 = 1;  //   Push-pull
  PD_CR2_bit.C22 = 1;  //   -  10 .

  PD_ODR_bit.ODR3 = 0;
  PD_DDR_bit.DDR3 = 1; // OVERRUN_UART
  PD_CR1_bit.C13 = 1;  //   Push-pull
  PD_CR2_bit.C23 = 1;  //   -  10 .

  PB_ODR_bit.ODR4 = 1;
  PB_DDR_bit.DDR4 = 1; // NOTOVERRUN_ACTIVE_UART
  PB_CR1_bit.C14 = 1;  //   Push-pull
  PB_CR2_bit.C24 = 1;  //   -  10 .
#endif  //UART_TIME_DEBUG
}

void UART_flush()
{
  // wait TC=1 before stop UART
  while(UART1_SR_bit.TC == 0);
}

void UART_send(const char* data, int len)
{
  // UDR=data (TXE hardvare cleared)
  while(len--) {
    while(!(UART1_SR & MASK_UART1_SR_TXE));
    UART1_DR = *(data++);
  }
}

// ---    UART ---

UART_RX_CALLBACK UART_RX_callback;

#pragma vector=UART1_T_TXE_vector
__interrupt void UART1_T_TXE_handler(void)
{
  //
}

#pragma vector=UART1_R_RXNE_vector
__interrupt void UART1_R_RXNE_handler(void)
{
#ifdef UART_TIME_DEBUG
  register char c, sr;
  sr = UART1_SR;
  if(sr & MASK_UART1_SR_RXNE)     // if were data
  {
    if(sr & MASK_UART1_SR_OR_LHE) // if were overrun
    {
      PB_ODR_bit.ODR4 = 0;
      PD_ODR_bit.ODR3 = 1;  // only setup
    }
    c = UART1_DR;
    PB_ODR_bit.ODR4 = 1;
    PD_ODR_bit.ODR2 = 1;
    UART_RX_callback(c);
    PD_ODR_bit.ODR2 = 0;
  }
#else   //UART_TIME_DEBUG
  if(UART1_SR & MASK_UART1_SR_RXNE)
  {
    UART_RX_callback(UART1_DR);
  }
#endif  //UART_TIME_DEBUG
}
