; --
; Copyright 2012 Angel5a
;
; Description:
;   Tray of using asm in c projects
;   The LCD_out module for Nokia 2760 external display
;
; $Revision: 0001 $
; --

#include "iostm8.h"

; ------------------------------
; - This is the 'LCD_out' module.

	module	LCD_out

	section	`.near_func.text`:CODE:NOROOT(0)

	public	LCD_init_hw
	public	LCD_reset
	public	LCD_data
	public	LCD_cmd
//	public	LCD_test

	extern	_delay_ms

LCD_init_hw:
	BSET	PA_ODR, #3	; SEL = 1
	BSET	PA_DDR, #3	; SSEL
	BSET	PA_CR1, #3	;   Push-pull
	BSET	PA_CR2, #3	;   -  10 .
	BSET	PC_ODR, #4	; RES = 1
	BSET	PC_DDR, #4	; RES
	BSET	PC_CR1, #4	;   Push-pull
	BSET	PC_CR2, #4	;   -  10 .
	BRES	PC_ODR, #5	; SCK = 0
	BSET	PC_DDR, #5	; SCK
	BSET	PC_CR1, #5	;   Push-pull
	BSET	PC_CR2, #5	;   -  10 .
	BSET	PC_DDR, #6	; MOSI
	BSET	PC_CR1, #6	;   Push-pull
	BSET	PC_CR2, #6	;   -  10 .
	RET

LCD_reset:
	LDW	X, #0x0064	; delay(100)
	CALL	_delay_ms
	BRES	PA_ODR, #3	; SEL = 0
	BRES	PC_ODR, #4	; RES = 0
	LDW	X, #0x0064	; delay(100)
	CALL	_delay_ms
	BSET	PC_ODR, #4	; RES = 0
	BSET	PA_ODR, #3	; SEL = 0
	LDW	X, #0x0064	; delay(100)
	JP	_delay_ms

LCD_cmd:
	BRES	PC_ODR, #6	; DAT = 0
	JRA	??LCD_send
LCD_data:
	BSET	PC_ODR, #6	; DAT = 1
??LCD_send:
	BRES	PA_ODR, #3	; SEL = 0
	BSET	PC_ODR, #5	; SCK = 1
	CLRW	X		; x = 0
	JRA	??LCD_send_0
??LCD_send_1:
	BRES	PC_ODR, #5	; SCK = 0
	SLA	A		; C = data & 0x80; data = data << 1
	BCCM	PC_ODR, #6	; DAT = C
	BSET	PC_ODR, #5	; SCK = 1
	INCW	X		; x = x + 1
??LCD_send_0:
	CPW	X, #8 
	JRSLT	??LCD_send_1	; while x < 8
	BRES	PC_ODR, #5	; SCK = 0
	BSET	PA_ODR, #3	; SEL = 1
	RET

/*
LCD_test:
	CLR	A		; loop {
??LCD_test_0:
	PUSH	A
	CLRW	Y		;  loop {
??LCD_test_1:
	CLR	A
	CALL	LCD_data	;   LCD_data(0)
	INCW	Y
	CPW	Y, #50000 
	JRNE	??LCD_test_1	;  } repeat 50000 times
	POP	A
	INC	A
	CP	A, #200 
	JRNE	??LCD_test_0	; } repeat 200 times
	RET
*/

	end
