// Warning! This file may be not included into project
//          in case of using lcdout.s instade

#include "iostm8.h"
#include "lcd.h"

// --- Configuration ---

// Warning! Change the LCD_init_hw function if you set different pins
//  HW SPI pins is: pc5 - sck, pc6 - mosi, pc7 - miso
#define LCD_SCK	PC_ODR_bit.ODR5
#define LCD_DAT	PC_ODR_bit.ODR6
#define LCD_SEL	PA_ODR_bit.ODR3
#define LCD_RES	PC_ODR_bit.ODR4

void _delay_ms(int ms);

#define LCD_OUT 1

// --- Implimentation ---

void LCD_init_hw()
{
  LCD_SEL = 1;
  PA_DDR_bit.DDR3 = 1; // SSEL
  PA_CR1_bit.C13 = 1;  //   Push-pull
  PA_CR2_bit.C23 = 1;  //   -  10 .
  
  LCD_RES = 1;
  PC_DDR_bit.DDR4 = 1; // RES
  PC_CR1_bit.C14 = 1;  //   Push-pull
  PC_CR2_bit.C24 = 1;  //   -  10 .

  LCD_SCK = 0;
  PC_DDR_bit.DDR5 = 1; // SCK
  PC_CR1_bit.C15 = 1;  //   Push-pull
  PC_CR2_bit.C25 = 1;  //   -  10 .
  
  //LCD_DAT = 1;
  PC_DDR_bit.DDR6 = 1; // MOSI
  PC_CR1_bit.C16 = 1;  //   Push-pull
  PC_CR2_bit.C26 = 1;  //   -  10 .
}

void LCD_reset(void) {
  _delay_ms(100);
  //  
  LCD_SEL = 0;
  LCD_RES = 0;
  _delay_ms(100);
  LCD_RES = 1;
  LCD_SEL = 1;
  _delay_ms(100);
}

// 1000   128  (771000 9)
// 0.   ~16   ~63 FPS  ~8000 /  ~434/
// 1.   ~12   ~83 FPS  ~10500 /  ~578/
// 3.   ~8   ~125 FPS  ~16000 /  ~867/

// 20050000 9  
// 3.   ~75   ~173FPS  ~22000 /  ~1.2/

#if LCD_OUT == 3
//#error Hardware output for SPI 9 bit is not implemented

#elif LCD_OUT == 2
#error Assembler software output is not implemented

#elif LCD_OUT == 1
// Software 8 bit output

void LCD_send ( unsigned char data ) {
  int i;
  LCD_SEL = 0;
  LCD_SCK = 1;
  for(i = 0; i < 8; i++) {
    LCD_SCK = 0;
    LCD_DAT = (data & 0x80) ? 1 : 0;
    LCD_SCK = 1;
    data <<= 1;
  }
  LCD_SCK = 0;
  LCD_SEL = 1;
}

void LCD_cmd(unsigned char cmd)
{
  LCD_DAT = 0;
  LCD_send(cmd);
}

void LCD_data(unsigned char data)
{
  LCD_DAT = 1;
  LCD_send(data);
}

#else
// Software 9 bit output

void LCD_send ( unsigned int data ) {
  char i;
  LCD_SEL = 0;
  for(i = 0; i < 9; i++) {
    LCD_DAT = (data & 0x100) ? 1 : 0;
    LCD_SCK = 1;
    data <<= 1;
    LCD_SCK = 0;
  }
  LCD_SEL = 1;
}

void LCD_cmd(unsigned char cmd)
{
  LCD_send(cmd);
}

void LCD_data(unsigned char data)
{
  LCD_send(0x0100|data);
}

#endif
