#include "font5x8.h"
#include "lcd.h"

void _delay_ms(int);

void LCD_init()
{
	LCD_init_hw();
//	LCD_cmd(0x11);	// SLEEPOUT
	LCD_reset();
	LCD_cmd(0xE2);
	_delay_ms(10);  //   
	LCD_cmd(0xAF);
	LCD_cmd(0xA4);
	LCD_cmd(0x2F);
	LCD_cmd(0xB0);	// Page
	LCD_cmd(0x10);
	LCD_cmd(0x00);	// Col low
}

void LCD_clear()
{
	int i;
	LCD_cmd(0xB0);
	LCD_cmd(0x10);
	LCD_cmd(0x00);
	for(i = 0; i < 9*96; i++)
		LCD_data(0xFF);
}

void LCD_drawchar(char c) {
	int i;
	const unsigned char *ptr = &font[5*(unsigned int)c];
	for(i = 0; i < 5; i++) {
		LCD_data(~ptr[i]);
	}
	LCD_data(0xFF); // 
}

void LCD_drawstr(const char *c) {
	while(*c) LCD_drawchar(*c++);
}

void LCD_setpos(char x, char y) {
	if(y > 9) y = 0;
	if(x > 96) x = 0;
	LCD_cmd(0xB0|(y));	//  
	LCD_cmd(0x10|(x>>4));	//  4   
	LCD_cmd(0x0F&(x));	//  4   
}

