#include "font5x8.h"
#include "lcd.h"

void _delay_ms(int);

// Nokia 1200
#define NOKIA1200

#define DISPLAY_WIDTH	96
#define DISPLAY_HEIGHT	9

#ifdef NOKIA1200

void LCD_init()
{
	LCD_init_hw();

	LCD_cmd( 0xE2 );  // Soft reset
	_delay_ms(10);
	  LCD_cmd( 0x3D );  // Charge pump
	  LCD_cmd( 0x01 );  // Charge pump = 4 (default 5 is too hight for 3.0 volt)
	  LCD_cmd( 0xE1 );  // Additional VOP for contrast increase
	  LCD_cmd( 0x16 );  // from -127 to +127
	LCD_cmd( 0xA4 );  // Power save OFF
	LCD_cmd( 0x2F );  // Booster ON Voltage regulator ON Voltage follover ON
	LCD_cmd( 0xAF );  // LCD on

	LCD_clear();
}

void LCD_clear()
{
	int i;
	LCD_setpos(0, 0);  	//  
	for(i = 0; i < DISPLAY_HEIGHT * DISPLAY_WIDTH; ++i) {
		LCD_data(0x00);	// 
	}
	LCD_setpos(0, 0);  	//  
}

void LCD_drawchar(char c) {
	int i;
	const unsigned char *ptr = &font[5*(unsigned int)c];
	for(i = 0; i < 5; i++) {
		LCD_data(ptr[i]);
	}
	LCD_data(0x00); 	// 
}

void LCD_drawstr(const char *c) {
	while(*c) LCD_drawchar(*c++);
}

void LCD_setpos(char x, char y) {
	if(x >= DISPLAY_WIDTH)	x = 0;
	if(y >= DISPLAY_HEIGHT)	y = 0;
	LCD_cmd(0xB0 | (y & 0x3F));	//row
	LCD_cmd(0x10 | (x>>4));		// Sets the DDRAM column address - upper 3-bit
	LCD_cmd(0x00 | (x & 0x0F));	// lower 4-bit
}

#endif  //NOKIA1200
